@echo OFF
REM ####################################################
REM ### VAS6356 Updater ################################
REM ####################################################
REM V1.0.9 -- 13.12.2024 -- Product-Key Duplikat geloescht
REM V1.0.8 -- MT 2023.11.06 Key hinzugefuegt
REM V1.0.7 -- Ordner ODIS_SetupLogs ersetzt durch Diag_SetupLogs
REM V1.0.6 -- MT 2021.1.29 Key hat sich nicht geändert
REM V1.0.5 -- - getMyDateMyTime - neu erstellt, um laenderspezifische Datumsformate zu verarbeiten
REM V1.0.4 -- MT 2020.05.15 Key hinzugefuegt
REM V1.0.3 -- Logausgabe MSIEXEC erweitert
REM			- Uninstaller Modul hinzugefuegt
REM			- Logfile Name Datum und Uhrzeit modifiziert
REM V1.0.2 -- MT 2020.04.10 Key hinzugefuegt
REM V1.0.1 -- MT 2019.12.16 Key hinzugefuegt
REM V1.0.0 -- Update VAS6356 & uninstall prev. versions

set SCRIPTVERSION=109
SET "path=%path%;C:\Windows\;C:\Windows\System32\;C:\Windows\System32\wbem"

REM ####################################################
REM ### Logfile setzen #################################
REM ####################################################
if not exist "%programdata%\Diag_SetupLogs" md "%programdata%\Diag_SetupLogs"
call :getMyDateMyTime
set logfile="%programdata%\Diag_SetupLogs\VAS6356_Installer_v%SCRIPTVERSION%_%myDate%_%myTime%.log"
call :LOG "%time%" ""



REM ####################################################
REM ### Install & Uninstall ############################
REM ####################################################
call :LOG ###
call :LOG "%time%" "Uninstall previous versions:"
echo Uninstall previous versions
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :UNINSTALL 2987D9C0-2AB5-473B-9712-B31F9D80653C
call :UNINSTALL FE684177-3CCA-4DF0-942A-48CB9EADB50B
call :UNINSTALL E1AF807E-F17B-49C7-9663-89BBC6796111
call :UNINSTALL CCC94AAC-93D3-4632-8A61-78C8A2B82C60
call :UNINSTALL FB8E94EF-8935-44E4-91C7-60024362768E
call :UNINSTALL 0FAE35F4-0B68-4F31-8722-47FD5D96EDFB
call :UNINSTALL F446EEBB-2C11-4A52-909F-025B18121DE3
call :UNINSTALL 641D48A6-5650-49B6-92C1-E30018BDE87F
call :UNINSTALL 24C2EB29-0C52-4EF9-B51E-36D10C10BECD
call :UNINSTALL A066AB6D-B725-4B42-977D-D89726F87822
call :UNINSTALL 87419B06-7D6F-4A42-9705-8EF8B4955236
call :UNINSTALL 88087EF1-DBB2-4D75-A367-8E6EC2DB94C1
call :UNINSTALL 36C9ED91-25B0-42C0-9DDF-16E79CDCA86C
call :UNINSTALL E8504B8B-B77E-4532-B624-875C827610AD
call :UNINSTALL B3C5AF3B-63A8-4803-A89B-D6DDFA5A5F5A


call :LOG ###
call :LOG "%time%" "Install new Version of setupVAS6356.msi:"
echo Install new Version of setupVAS6356.msi:
cd %~dp0
msiexec /i setupVAS6356.msi /quiet /L*v "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile% 2>&1
SET wert=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert%"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - MSI Logfile:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
type "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile%
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"

call :LOG ###
call :LOG "%time%" "Terminating script with: %wert%"
exit /B %wert%



REM ####################################################
REM ### Tools ##########################################
REM ####################################################

REM ####################################################
REM ### MSI UNINSTALLER ################################
REM ####################################################
:UNINSTALL
call :LOG "%time%" "- - - uninstalling MsiExec Code %1  - - - - - - - -"
MsiExec /x{%1} /qn /norestart /L*v "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile% 2>&1
SET wert=%ERRORLEVEL%
call :LOG "%time%" "- - - RETURNCODE: %wert%  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - MSI Logfile:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
type "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile%
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
goto :EOF



REM ############################################################
REM ### get Date and Time ######################################
REM ############################################################
:getMyDateMyTime
set myDate=%date:\=%
set myDate=%myDate:/=%
set myDate=%myDate::=%
set myDate=%myDate:^*=%
set myDate=%myDate:?=%
set myDate=%myDate:<=%
set myDate=%myDate:>=%
set myDate=%myDate:|=%
set myDate=%myDate: =0%
set myTime=%TIME::=%
set myTime=%myTime:;=%
set myTime=%myTime:,=%
set myTime=%myTime: =0%
goto :EOF


REM ####################################################
REM ### Logger #########################################
REM ####################################################
:LOG
if not exist %logfile% (
	echo.> %logfile%
	echo ############################### >> %logfile%
	echo ### VAS6356 Installer       ### >> %logfile%
	echo ### Version:  %SCRIPTVERSION:~0,1%.%SCRIPTVERSION:~1,1%.%SCRIPTVERSION:~2,1%         ### >> %logfile%
	echo ### Starte Log %logfile% ### >> %logfile%
	echo ### Datum %date%  Zeit %time:~0,2%:%time:~3,2%:%time:~6,2% ### >> %logfile%
	echo ############################### >> %logfile%
	echo.>> %logfile%
	)
if %1.==###. (
	echo.>> %logfile%
	echo "%time%" ################################################## >> %logfile%
) else (
	echo %1 ### %2 %3 %4 %5 %6 %7 %8 %9 >> %logfile%
)
goto :EOF