@echo OFF
REM ####################################################
REM ### VAS6558A Updater ###############################
REM ####################################################
REM V1.1.0 -- 13.12.2024 -- Product-Key Duplikat geloescht
REM V1.0.9 -- 27.09.2024 -- Product-Key zum Loeschen hinzugefuegt
REM V1.0.8 -- Ordner ODIS_SetupLogs ersetzt durch Diag_SetupLogs
REM V1.0.7 -- MT 2021.1.29 Key hinzugefuegt
REM V1.0.6 -- - getMyDateMyTime - neu erstellt, um laenderspezifische Datumsformate zu verarbeiten
REM V1.0.5 -- MT 2020.05.15 Key hinzugefuegt
REM V1.0.4 -- Logausgabe MSIEXEC erweitert
REM			- Uninstaller Modul hinzugefuegt
REM			- Logfile Name Datum und Uhrzeit modifiziert
REM V1.0.3 -- MT 2020.04.10 Key hinzugefuegt
REM V1.0.2 -- Dei umbennant und das A entfernt, Echo ausgabe korrigiert
REM V1.0.1 -- MT 2019.12.16 Key hinzugefuegt
REM V1.0.0 -- Update VAS6558A & uninstall prev. versions

set SCRIPTVERSION=110
SET "path=%path%;C:\Windows\;C:\Windows\System32\;C:\Windows\System32\wbem"

REM ####################################################
REM ### Logfile setzen #################################
REM ####################################################
if not exist "%programdata%\Diag_SetupLogs" md "%programdata%\Diag_SetupLogs"
call :getMyDateMyTime
set logfile="%programdata%\Diag_SetupLogs\VAS6558A_Installer_v%SCRIPTVERSION%_%myDate%_%myTime%.log"
call :LOG "%time%" ""



REM ####################################################
REM ### Install & Uninstall ############################
REM ####################################################
call :LOG ###
call :LOG "%time%" "Uninstall previous versions:"
echo Uninstall previous versions
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :UNINSTALL 5ED6685E-3DBD-40D8-A148-6D6E8B0EC45A
call :UNINSTALL 4B77BB31-983A-4BF5-BE6D-AB16874E54F4
call :UNINSTALL 3541676A-3D2F-400C-AC66-887FEB8D2D46
call :UNINSTALL 4E86B321-32AB-4D46-A5F0-4AF61532A638
call :UNINSTALL EF9B77B5-1054-41EB-B166-653CB976CED0
call :UNINSTALL 27144761-F8F5-46B1-8B44-6E784467C56E
call :UNINSTALL 257A5A08-D320-4AD6-9E80-C7305F502A71
call :UNINSTALL 0095E2A2-80DF-4823-8FC9-512943252F4A
call :UNINSTALL 8E63258B-4A93-49B3-A594-FEEDF3A92119
call :UNINSTALL 08AFB0A8-B675-4118-B4BB-510BF1BCA055
call :UNINSTALL 02DAA718-810F-45AE-A8AB-2F97FD223A03
call :UNINSTALL 2230812F-521E-46F9-BFB1-0C3F19B88325
call :UNINSTALL 29F518CF-34B5-4B38-8FF5-DDDD6C610E78
call :UNINSTALL E4C05A7F-A64A-43F0-87DE-8E61E5B55A8F
call :UNINSTALL AD196694-C13D-47B5-BA41-1AAE658C4751
call :UNINSTALL 4F917E7C-4EF8-4881-818F-8D8992D83FF0
call :UNINSTALL F7CC0C20-0D30-48EC-A3E5-94C1DAF323A7
call :UNINSTALL 10630859-E1A5-4B51-BB2F-A5FE80F126C8


call :LOG ###
call :LOG "%time%" "Install new Version of setupVAS6558A.msi:"
echo Install new Version of setupVAS6558A.msi:
cd %~dp0
msiexec /i setupVAS6558A.msi /quiet /L*v "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile% 2>&1
SET wert=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert%"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - MSI Logfile:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
type "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile%
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"

call :LOG ###
call :LOG "%time%" "Terminating script with: %wert%"
exit /B %wert%



REM ####################################################
REM ### Tools ##########################################
REM ####################################################

REM ####################################################
REM ### MSI UNINSTALLER ################################
REM ####################################################
:UNINSTALL
call :LOG "%time%" "- - - uninstalling MsiExec Code %1  - - - - - - - -"
MsiExec /x{%1} /qn /norestart /L*v "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile% 2>&1
SET wert=%ERRORLEVEL%
call :LOG "%time%" "- - - RETURNCODE: %wert%  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - MSI Logfile:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
type "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile%
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
goto :EOF



REM ############################################################
REM ### get Date and Time ######################################
REM ############################################################
:getMyDateMyTime
set myDate=%date:\=%
set myDate=%myDate:/=%
set myDate=%myDate::=%
set myDate=%myDate:^*=%
set myDate=%myDate:?=%
set myDate=%myDate:<=%
set myDate=%myDate:>=%
set myDate=%myDate:|=%
set myDate=%myDate: =0%
set myTime=%TIME::=%
set myTime=%myTime:;=%
set myTime=%myTime:,=%
set myTime=%myTime: =0%
goto :EOF


REM ####################################################
REM ### Logger #########################################
REM ####################################################
:LOG
if not exist %logfile% (
	echo.> %logfile%
	echo ############################### >> %logfile%
	echo ### VAS6558A Installer      ### >> %logfile%
	echo ### Version:  %SCRIPTVERSION:~0,1%.%SCRIPTVERSION:~1,1%.%SCRIPTVERSION:~2,1%         ### >> %logfile%
	echo ### Starte Log %logfile% ### >> %logfile%
	echo ### Datum %date%  Zeit %time:~0,2%:%time:~3,2%:%time:~6,2% ### >> %logfile%
	echo ############################### >> %logfile%
	echo.>> %logfile%
	)
if %1.==###. (
	echo.>> %logfile%
	echo "%time%" ################################################## >> %logfile%
) else (
	echo %1 ### %2 %3 %4 %5 %6 %7 %8 %9 >> %logfile%
)
goto :EOF