@echo off
color 08

set SCRIPTVERSION=170

REM V1.7.0 -- 11.04.2025 -- # [OS] [OE]	- Path fuer WMIC - entfernt
REM 						# [OS] [OE]	- :MOD_JAVA_SECURITY - entfernt
REM V1.6.0 -- 28.03.2025 -- # [OS] [  ]	- Keine inhaltliche Aenderung - Hoch nummeriert damit das Skript beim Update auch funktioniert
REM V1.5.0 -- 04.03.2025 -- # [OS] [  ]	- :MOD_MB_APPSETTINGS fuer OS - Parallelbetrieb HV Messmodul und Modul Balancer
REM V1.4.0 -- 28.02.2025 -- # [OS] [OE]	- :CLEANUP_DIAG_SETUPLOGS erstellt - Cleanup des Diag_SetupLogs Ordners
REM                         # [OS] [  ]	- :MOD_MB_LOGGERSETTINGS - Anpassung des Log-Pfads
REM                         # [  ] [OE]	- :DELETE_SAC nur fuer OE
REM                         # [  ] [OE]	- :DELETE_LEGAL nur fuer OE
REM V1.3.0 -- 26.01.2024 -- # [  ] [OE]	- Deaktivierung :MOD_JAVA_SECURITY fuer OE
REM V1.2.0 -- 25.10.2023 -- # [  ] [OE]	- jdk.certpath.disabledAlgorithms in der java.security um rsa_pss_rsae_sha256, rsa_pss_rsae_sha384 und rsa_pss_rsae_sha512 erweitert
REM V1.1.0 -- 23.10.2023 -- # [OS] [OE]	- Legal-Verzeichnis wird komplett entfernt
REM V1.0.5 -- 11.08.2023 -- # [OS] [OE]	- SAC-Verzeichnis wird komplett entfernt wenn SAC in der ODIS Version deaktiviert ist
REM V1.0.4 -- 14.06.2023 -- # [OS] [OE]	- :DELETE_SAC und :CHECK_ADMIN_RIGHTS erstellt
REM V1.0.3 -- 31.01.2023 -- # [OS] [OE]	- Das Praefix "ODIS" der Logdatei und des Logordners ersetzt durch "Diag" aus der Version V1.0.0
REM V1.0.0 -- 20.04.2021 -- # [OS] [OE]	- Initiale Version - keine Inhalte - keine Aktivitaeten


REM ####################################################
REM ### Returnvariablen definieren #####################
REM ####################################################
set SUCCESS=0
set REBOOT=0
set FAILURE=0

REM ####################################################
REM ### Logfile setzen #################################
REM ####################################################
if not exist "%programdata%\Diag_SetupLogs" md "%programdata%\Diag_SetupLogs"
call :getMyDateMyTime
set logfile="%programdata%\Diag_SetupLogs\diag_PLU_v%SCRIPTVERSION%_%myDate%_%myTime%.log"
call :LOG "%time%" ""

REM ####################################################
REM ### Uebergabeparameter & Sonstiges #################
REM ####################################################
call :LOG "%time%" "Uebergabeparameter 1   (Product): %~1"
call :LOG "%time%" "Uebergabeparameter 2 (ODIS Path): %~2"
call :LOG "%time%" "Uebergabeparameter 3            : %~3"
call :LOG "%time%" ""
call :LOG "%time%" ""
for /f "tokens=*" %%i in ('ver') do set WindowsBuildNumber=%%i
call :LOG "%time%" "    Windows Version: %WindowsBuildNumber%"
call :LOG "%time%" "Aktueller Dateipfad: %~dp0"
call :LOG "%time%" "     Aktuelle Datei: %0"
call :LOG "%time%" "               Temp: %temp%"

cd %~dp0
set ODIS_product=%~1
REM set ODIS_path=%~2

GOTO :CHECK_ADMIN_RIGHTS


REM ##################################################################
REM #### Check Admin Rights ##########################################
REM ##################################################################
:CHECK_ADMIN_RIGHTS
call :LOG ###
call :LOG "%time%" "Check Admin rights"
net session >nul 2>&1
if %ERRORLEVEL% == 0 (
	call :LOG "%time%" " 	... user has Admin rights."

) else (
	call :LOG "%time%" " 	... user has no Admin rights."
	set NOADMIN=1
)
GOTO :DELETE_LEGAL


REM ##############################################
REM ### Delete Legal folder ######################
REM ##############################################
:DELETE_LEGAL

if %ODIS_product%.==OS. GOTO :DELETE_LEGAL_FINISH

call :LOG ###
call :LOG "%time%" "Delete Legal folder"

set legalPath=%ProgramFiles%\%ODIS_product%\Legal
call :LOG "%time%" " 	- The path of Legal folder is: %legalPath%"

if not exist "%legalPath%" (
	call :LOG "%time%" "Legal folder does not exist"
	GOTO :DELETE_LEGAL_FINISH
)

REM ### Delete Legal folder
call :LOG "%time%" " 	- Deleting Legal folder ..."
rd "%legalPath%" /s /q >>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" "	- Delete Legal folder completed with: %wert%"

:DELETE_LEGAL_FINISH
SET SUCCESS=1
GOTO :DELETE_SAC


REM ##############################################
REM ### Delete SAC folder ########################
REM ##############################################
:DELETE_SAC

if %ODIS_product%.==OS. GOTO :DELETE_SAC_FINISH

call :LOG ###
call :LOG "%time%" "Delete SAC folder"

set sacPath=%ProgramFiles%\%ODIS_product%\SAC
call :LOG "%time%" " 	- The path of SAC folder is: %sacPath%"

if not exist "%sacPath%" (
	call :LOG "%time%" "SAC folder does not exist"
	GOTO :DELETE_SAC_FINISH
)

REM ### Delete SAC folder
call :LOG "%time%" " 	- Deleting SAC folder ..."
rd "%sacPath%" /s /q >>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" "	- Delete SAC folder completed with: %wert%"

:DELETE_SAC_FINISH
SET SUCCESS=1
GOTO :MOD_MB_LOGGERSETTINGS


REM ############################################################
REM ### MOD MB loggerSettings.json #############################
REM ############################################################
:MOD_MB_LOGGERSETTINGS
setlocal EnableDelayedExpansion

REM ### Only OS relevant ###
if %ODIS_product%.==OE. GOTO :MOD_MB_LOGGERSETTINGS_FINISH

call :LOG ###
call :LOG "%time%" "Update Module Balancer logger settings"

REM ### File name and file directory ###
set "fileName=loggerSettings.json"
set "fileDir=%ProgramFiles%\DiTest\EmobServiceGRPC"
set "fileFullPath=%fileDir%\%fileName%"
set "tempFile=%fileDir%\temp.txt"
set "searchString=%%APPDATA%%/DiTEST/EmobServiceGRPC/Logs/log.txt"
set "replaceString=%%ProgramData%%/Diag_SetupLogs/DiTEST/EmobServiceGRPC/log.txt"
set "logDir=%ProgramData%\Diag_SetupLogs\DiTEST\EmobServiceGRPC"

call :LOG "%time%" " 	The path of the loggerSettings.json file is: %fileFullPath%"

REM ### Create MB log folder if necessary
if not exist "%logDir%" (
	call :LOG "%time%" " 	The folder %logDir% will be created."
	md "%logDir%" >>%logfile% 2>&1
	REM ### Users without admin rights can delete the folder
	call :LOG "%time%" " 	Permission change of the folder DiTEST so that users without admin rights can delete it"
	icacls "%ProgramData%\Diag_SetupLogs\DiTEST" /grant Users:F /T >>%logfile% 2>&1
)

REM ### Check if the logger setting file exists
if not exist "%fileFullPath%" (
	call :LOG "%time%" " 	The loggerSettings.json file is not found. Script will continue running."
	GOTO :MOD_MB_LOGGERSETTINGS_FINISH
)

REM ### Check if the logger setting file already updated ###
call :LOG "%time%" " 	Check if the logger setting file already updated"
findstr /C:"%replaceString%" "%fileFullPath%" > nul
if %ERRORLEVEL%==0 (
	call :LOG "%time%" " 	Found required adjustment in the %fileName% file, update is NOT necessary!"
	GOTO :MOD_MB_LOGGERSETTINGS_FINISH
)
call :LOG "%time%" " 	NOT found required adjustment in the %fileName% file, update is necessary!"

REM ### Create backup file ###
if not exist "%fileDir%\ORIGINAL_%fileName%" (
	call :LOG "%time%" " 	Creating backup file"
	copy "%fileFullPath%" "%fileDir%\ORIGINAL_%fileName%" /Y >>%logfile% 2>&1
	set wert=%ERRORLEVEL%
	call :LOG "%time%" " 	Create backup file completed with: %wert%"
)

REM ### Update file ###
call :LOG "%time%" " 	Updating file..."
(for /f "delims=" %%i in ('type "%fileFullPath%"') do (
    set "line=%%i"
    set "line=!line:%searchString%=%replaceString%!"
    echo !line!
)) > "%tempFile%"

REM ### The original file is replaced by the temp file ###
move /Y "%tempFile%" "%fileFullPath%"

call :LOG "%time%" " 	Update %fileName% file completed with: %ERRORLEVEL%!"

:MOD_MB_LOGGERSETTINGS_FINISH
endlocal
SET SUCCESS=1
GOTO :MOD_MB_APPSETTINGS


REM ############################################################
REM ### MOD MB appsettings.json ################################
REM ############################################################
:MOD_MB_APPSETTINGS
setlocal EnableDelayedExpansion

REM ### Only OS relevant ###
if %ODIS_product%.==OE. GOTO :MOD_MB_APPSETTINGS_FINISH

call :LOG ###
call :LOG "%time%" "Update Module Balancer app settings"

REM ### File name and file directory ###
set "fileName=appsettings.json"
set "fileDir=%ProgramFiles%\DiTest\EmobServiceGRPC"
set "fileFullPath=%fileDir%\%fileName%"
set "tempFile=%fileDir%\temp.txt"

call :LOG "%time%" " 	The path of the appsettings.json file is: %fileFullPath%"

REM ### Flags to track the sections ###
set "inHvSafety=false"
set "inWorkSafe=false"

REM ### Check if the app setting file exists ###
if not exist "%fileFullPath%" (
	call :LOG "%time%" " 	The appsettings.json file is not found. Script will continue running."
	GOTO :MOD_MB_APPSETTINGS_FINISH
)

REM ### Create backup file ###
if not exist "%fileDir%\ORIGINAL_%fileName%" (
	call :LOG "%time%" " 	Creating backup file"
	copy "%fileFullPath%" "%fileDir%\ORIGINAL_%fileName%" /Y >>%logfile% 2>&1
	set wert=%ERRORLEVEL%
	call :LOG "%time%" " 	Create backup file completed with: %wert%"
)

REM ### Read the JSON file and replace the values ###
(for /f "delims=" %%i in ('type "%fileFullPath%"') do (
    set "line=%%i"
    
    REM ### Check if the HvSafety section bas been reached ###
    echo %%i | findstr /c:"\"AVL.DiTEST.HvSafety\":" >nul && set "inHvSafety=true" && set "inWorkSafe=false"
    
    REM ### Check if the WorkSafe section has been reached ###
    echo %%i | findstr /c:"\"AVL.DiTEST.WorkSafe\":" >nul && set "inWorkSafe=true" && set "inHvSafety=false"
    
    REM ### Set the value of the parameter "Enabled" to "false" only in the specified sections ###
    if "!inHvSafety!"=="true" (
        set "line=!line:"Enabled": "true"="Enabled": "false"!"
    ) else if "!inWorkSafe!"=="true" (
        set "line=!line:"Enabled": "true"="Enabled": "false"!"
    )
	
    REM ### Other lines will not be changed ###
    echo !line!>> "%tempFile%"
))

REM ### The original file is replaced by the temp file ###
move /Y "%tempFile%" "%fileFullPath%"

call :LOG "%time%" " 	Update %fileName% file completed with: %ERRORLEVEL%!"

:MOD_MB_APPSETTINGS_FINISH
endlocal
SET SUCCESS=1
GOTO :CLEANUP_DIAG_SETUPLOGS


REM ##############################################
REM ### Cleanup Diag_SetupLogs folder ############
REM ##############################################
:CLEANUP_DIAG_SETUPLOGS
call :LOG ###
call :LOG "%time%" "Cleanup Diag_SetupLogs folder"

setlocal enabledelayedexpansion

REM ### Set the target directory
set "TARGET_DIR=C:\ProgramData\Diag_Setuplogs"

if not exist "%TARGET_DIR%" (
	call :LOG "%time%" "Diag_Setuplogs folder does not exist"
	GOTO :CLEANUP_DIAG_SETUPLOGS_FINISH
)

REM ### Delete files older than 6 months
forfiles /p "%TARGET_DIR%" /s /m *.* /d -180 /c "cmd /c del /f /q @path"
call :LOG "%time%" "	- Delete files older than 6 months completed"

REM ### Delete files larger than 10 MB
for /r "%TARGET_DIR%" %%F in (*) do (
    set "size=%%~zF"
    if !size! GTR 10485760 del /f /q "%%F"
)
call :LOG "%time%" "	- Delete files larger than 10 MB completed"

:CLEANUP_DIAG_SETUPLOGS_FINISH
endlocal
set SUCCESS=1
GOTO :END_SCRIPT


REM ############################################################
REM ### get Date and Time ######################################
REM ############################################################
:getMyDateMyTime
set myDate=%date:\=%
set myDate=%myDate:/=%
set myDate=%myDate::=%
set myDate=%myDate:^*=%
set myDate=%myDate:?=%
set myDate=%myDate:<=%
set myDate=%myDate:>=%
set myDate=%myDate:|=%
set myDate=%myDate: =0%
set myTime=%TIME::=%
set myTime=%myTime:;=%
set myTime=%myTime:,=%
set myTime=%myTime: =0%
goto :EOF


REM ####################################################
REM ### Logger #########################################
REM ####################################################
:LOG
if not exist %logfile% (
	echo.> %logfile%
	echo ############################### >> %logfile%
	echo ### ODIS Patch Last Update  ### >> %logfile%
	echo ### Version:  %SCRIPTVERSION:~0,1%.%SCRIPTVERSION:~1,1%.%SCRIPTVERSION:~2,1%         ### >> %logfile%
	echo ### Starte Log %logfile% ### >> %logfile%
	echo ### Datum %date%  Zeit %time:~0,2%:%time:~3,2%:%time:~6,2% ### >> %logfile%
	echo ############################### >> %logfile%
	echo.>> %logfile%
	)
if %1.==###. (
	echo.>> %logfile%
	echo "%time%" ################################################## >> %logfile%
) else (
	echo %1 ### %2 %3 %4 %5 %6 %7 %8 %9 >> %logfile%
)
goto :EOF



REM ####################################################
REM #### ENDMODULES ####################################
REM ####################################################

REM #### END_SCRIPT ############
:END_SCRIPT
call :LOG ###
call :LOG "%time%" "Terminating the script"
call :LOG "%time%" " 	SUCCESS: %SUCCESS%"
call :LOG "%time%" " 	REBOOT: %REBOOT%"
call :LOG "%time%" " 	NOADMIN: %NOADMIN%"
call :LOG "%time%" " 	FAILURE: %FAILURE%"
if %FAILURE%% EQU 1 GOTO NOK
if %REBOOT%% EQU 1 GOTO REBOOT
REM if %NOADMIN%% EQU 1 GOTO NOADMIN
if %SUCCESS%% EQU 1 GOTO OK
GOTO :EXCEPTION

REM #### OK ############
:OK
call :LOG ###
call :LOG "%time%" "! ! ! Script finished successfully ! ! !"
EXIT /B 0

REM #### NOK ############
:NOK
call :LOG ###
call :LOG "%time%" "! ! ! Script failed ! ! !"
C:\Windows\System32\msg.exe * "!!! Error! Contact your Administrator !!!" >>%logfile% 2>&1
EXIT /B 1

REM #### REBOOT #########
:REBOOT
call :LOG ###
call :LOG "%time%" "Script finished successfully, but needs reboot. --- Script will show failure"
C:\Windows\System32\msg.exe * "!!! Please REBOOT your Computer and run ODIS UPDATE again !!!" >>%logfile% 2>&1
EXIT /B 2

REM #### EXCEPTION ############
:EXCEPTION
call :LOG ###
call :LOG "%time%" "!!! UNKNOWN ERROR ! Contact your Administrator !!!"
C:\Windows\System32\msg.exe * "!!! ERROR - Contact your administrator !!!" >>%logfile% 2>&1
EXIT /B 3

REM #### NOADMIN #########
:NOADMIN
call :LOG ###
call :LOG "%time%" "User has no admin rights!"
C:\Windows\System32\msg.exe * "User has no admin rights!" >>%logfile% 2>&1
EXIT /B 4