/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.index;

import de.vw.vaudes.diaghook.DiagnosticDataIndicationException;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.IndicatedEquipmentNodeElement;
import de.vw.vaudes.diaghook.index.IndicatedPresetMeasurementElement;
import de.vw.vaudes.diaghook.index.IndicatedTestProgramElement;
import de.vw.vaudes.diaghook.index.ext.ExtendedDataIndicator;
import de.vw.vaudes.diaghook.index.ext.rule.EquipmentNodeExtIndicationRule;
import de.vw.vaudes.diaghook.index.ext.rule.PresetMeasurementIndicationRule;
import de.vw.vaudes.diaghook.index.ext.rule.TestprogramIndicationRule;
import de.vw.vaudes.diaghook.index.fkc.FunctiontestIndicator;
import de.vw.vaudes.diaghook.security.InvalidDigestException;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessException;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.diaghook.util.JaxbUtils;
import de.vw.vaudes.xml.instpackage.TeilpaketTYPE;
import de.vw.vaudes.xml.instpackage.VAUDESInstallationspaket;
import de.vw.vaudes.xml.object.TextquelleDOM;
import de.vw.vaudes.xml.partpackage.ObjektdateiDOM;
import de.vw.vaudes.xml.partpackage.VAUDESTeilpaket;
import java.io.File;
import java.net.URL;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXB;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ObjectIndicator {
    private final Log fLogger = LogFactory.getLog(this.getClass());
    private static ObjectIndicator fINSTANCE = new ObjectIndicator();
    private final Map<String, IndicatedElement> fObjectIdIndex = new HashMap<String, IndicatedElement>();
    private final Map<String, IndicatedElement> fTemporaryObjectIndex = new HashMap<String, IndicatedElement>();
    private final Map<String, IndicatedElement> fSystemNameIndex = new HashMap<String, IndicatedElement>();
    private final Map<String, IndicatedElement> fRuntimeObjectIdIndex = new HashMap<String, IndicatedElement>();
    private final Map<String, IndicatedElement> fRuntimeSystemNameIndex = new HashMap<String, IndicatedElement>();
    private String fBaselineVersion;
    private final ExtendedDataIndicator fExtendedIndicator = new ExtendedDataIndicator();
    private String fTestbaselineVersion;
    private String fBrand;
    private boolean fTblMode;

    private ObjectIndicator() {
        this.fExtendedIndicator.addRule(new EquipmentNodeExtIndicationRule());
        this.fExtendedIndicator.addRule(new PresetMeasurementIndicationRule());
        this.fExtendedIndicator.addRule(new TestprogramIndicationRule());
    }

    public static ObjectIndicator getInstance() {
        return fINSTANCE;
    }

    public IndicatedElement getObjectByIdOrSysName(String string) {
        String string2 = this.convert(string);
        IndicatedElement indicatedElement = this.getObjectIndex().get(string2);
        if (null == indicatedElement) {
            indicatedElement = this.getSystemNameIndex().get(string2);
        }
        return indicatedElement;
    }

    public IndicatedElement getObjectById(String string) {
        return this.getObjectIndex().get(this.convert(string));
    }

    public IndicatedElement getObjectBySystemname(String string) {
        return this.getSystemNameIndex().get(this.convert(string));
    }

    public void indicateGfs(URL uRL) throws DiagnosticDataIndicationException {
        this.getTemporaryObjectIndex().clear();
        File file = FileUtils.toFile((URL)uRL);
        if (null == file || !file.exists() || !file.canRead()) {
            this.fLogger.error((Object)("error reading url: " + uRL));
            throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.PATH_NOT_FOUND_OR_READABLE);
        }
        VAUDESTeilpaket vAUDESTeilpaket = this.getTeilPaketIndexfile(file);
        if (null != vAUDESTeilpaket) {
            File file2 = null;
            file2 = file.isFile() ? file.getParentFile() : file;
            try {
                this.indicateTeilpaket(vAUDESTeilpaket, file2, null);
            }
            catch (DiagnosticDataAccessException diagnosticDataAccessException) {
                throw this.buildException(diagnosticDataAccessException);
            }
            this.commit();
            this.fExtendedIndicator.indicate(this.getTemporaryObjectIndex());
        }
        FunctiontestIndicator.getInstance().indicateFunctiontest(file);
    }

    public void indicateHotfix(URL uRL) throws DiagnosticDataIndicationException {
        this.getTemporaryObjectIndex().clear();
        File file = FileUtils.toFile((URL)uRL);
        if (null == file || !file.exists() || !file.canRead()) {
            this.fLogger.error((Object)("Error reading url: " + uRL));
            throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.PATH_NOT_FOUND_OR_READABLE);
        }
        this.doIndicateHotfix(file);
        this.commit();
        this.fExtendedIndicator.indicate(this.getTemporaryObjectIndex());
    }

    private void commit() {
        this.getObjectIndex().putAll(this.getRuntimeObjectIndex());
        this.getRuntimeObjectIndex().clear();
        this.getSystemNameIndex().putAll(this.getRuntimeSystemNameIndex());
        this.getRuntimeSystemNameIndex().clear();
    }

    private void doIndicateHotfix(File file) throws DiagnosticDataIndicationException {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.isFile()) {
            if (file.getName().equals("installation_index.xml")) {
                arrayList.add(file);
            } else {
                File file2 = file.getParentFile();
                if (null != file2) {
                    arrayList.add(new File(file2.getAbsolutePath(), "installation_index.xml"));
                }
            }
        } else {
            arrayList.addAll(FileUtils.listFiles((File)file, (IOFileFilter)new IOFileFilter(){

                public boolean accept(File file) {
                    return "installation_index.xml".equalsIgnoreCase(file.getName());
                }

                public boolean accept(File file, String string) {
                    return false;
                }
            }, (IOFileFilter)TrueFileFilter.INSTANCE));
        }
        if (arrayList.isEmpty()) {
            this.fLogger.warn((Object)("No installation index file(s) found at " + file));
            throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.STRUCTURE_INVALID);
        }
        for (File file3 : arrayList) {
            this.doIndicateInstallationsPaket(file3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VAUDESTeilpaket getTeilPaketIndexfile(File file) throws DiagnosticDataIndicationException {
        File file2;
        File file3 = null;
        VAUDESTeilpaket vAUDESTeilpaket = null;
        if (!file.isDirectory()) {
            file2 = file.getParentFile();
            if (null == file2) {
                this.fLogger.error((Object)("Error during caching: no index file given at " + file));
                return vAUDESTeilpaket;
            }
            file3 = file2;
        } else {
            file3 = file;
        }
        if (null == (file2 = new File(file3.getAbsolutePath(), "index.xml")) || !file2.exists() || !file2.canRead()) {
            this.fLogger.warn((Object)("no index (teilpaket-) file found at: " + file3 + " [assumed filname: index.xml]. Ignore this warning if a single function test gets indicated."));
            return vAUDESTeilpaket;
        }
        try {
            return JaxbUtils.unmarshal(file2, VAUDESTeilpaket.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.fLogger.error((Object)("can't unmarshal teilpaket file " + file2));
            throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.STRUCTURE_INVALID);
        }
    }

    private void indicateTeilpaket(VAUDESTeilpaket vAUDESTeilpaket, File file, File file2) throws DiagnosticDataAccessException {
        for (VAUDESTeilpaket.Verteildateien.Datei datei : vAUDESTeilpaket.getVerteildateien().getDatei()) {
            if (!datei.getValue().toLowerCase().startsWith("obj_") || !datei.getValue().toLowerCase().endsWith(".xml")) continue;
            try {
                this.doIndicateTeilpaket(datei, file.toURI().toURL(), file2);
            }
            catch (Exception exception) {
                this.fLogger.error((Object)("Error while caching teilpaket from file " + file), (Throwable)exception);
                throw new DiagnosticDataAccessException("Error while caching teilpaket from file " + file, exception);
            }
        }
    }

    private void doIndicateTeilpaket(VAUDESTeilpaket.Verteildateien.Datei datei, URL uRL, File file) {
        if (null != datei.getObjektId() && this.getObjectIndex().containsKey(datei.getObjektId())) {
            this.fLogger.warn((Object)("Object id on index gets overwritten: " + datei.getObjektId()));
        }
        if (null != datei.getObjektSysname() && this.getSystemNameIndex().containsKey(datei.getObjektSysname())) {
            this.fLogger.warn((Object)("Object sysname on index gets overwritten: " + datei.getObjektSysname()));
        }
        IndicatedElement indicatedElement = null;
        indicatedElement = datei.getObjekttyp().equals((Object)ObjektdateiDOM.AUSSTATTUNGSMERKMAL) ? new IndicatedEquipmentNodeElement(datei.getObjektId(), uRL, datei, file) : (datei.getObjekttyp().equals((Object)ObjektdateiDOM.VOREINGESTELLTE_MESSUNG) ? new IndicatedPresetMeasurementElement(datei.getObjektId(), uRL, datei, file) : (datei.getObjekttyp().equals((Object)ObjektdateiDOM.FUNKTIONSCODE) ? new IndicatedTestProgramElement(datei.getObjektId(), uRL, datei, file) : new IndicatedElement(datei.getObjektId(), uRL, datei, file)));
        this.getTemporaryObjectIndex().put(datei.getObjektId(), indicatedElement);
        this.getRuntimeObjectIndex().put(datei.getObjektId(), indicatedElement);
        this.getRuntimeSystemNameIndex().put(datei.getObjektSysname(), indicatedElement);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("Added " + datei.getValue() + " to index [" + datei.getObjektId() + "/" + datei.getObjektSysname() + "]"));
        }
    }

    private void doIndicateInstallationsPaket(File file) throws DiagnosticDataIndicationException {
        VAUDESInstallationspaket vAUDESInstallationspaket;
        try {
            vAUDESInstallationspaket = (VAUDESInstallationspaket)JAXB.unmarshal((File)file, VAUDESInstallationspaket.class);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error while unmarshalling installation teilpaket file " + file), (Throwable)exception);
            throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.STRUCTURE_INVALID, (Throwable)exception);
        }
        String string = this.getBaselineVersion();
        boolean bl = false;
        if (!StringUtils.isEmpty((String)string) && !StringUtils.equals((String)string, (String)"0.0.0")) {
            if (string.equalsIgnoreCase(vAUDESInstallationspaket.getReferenzBaseline())) {
                this.fLogger.info((Object)"Found suitable hotfix baseline number");
                bl = true;
            } else {
                this.fLogger.warn((Object)("Indicating diagnostic data declined: service baseline is " + string + ", hotfix baseline is " + vAUDESInstallationspaket.getReferenzBaseline()));
            }
        } else {
            this.fLogger.warn((Object)"Indicating diagnostic data without knowledge of baseline number used in service ...");
            bl = true;
        }
        if (bl) {
            for (VAUDESInstallationspaket.Teilpakete.Datei datei : vAUDESInstallationspaket.getTeilpakete().getDatei()) {
                if (!datei.getTpTyp().equals((Object)TeilpaketTYPE.STRUKTUR_TP)) continue;
                String string2 = StringUtils.substringBeforeLast((String)file.getAbsolutePath(), (String)File.separator);
                File file2 = new File(string2, datei.getValue());
                if (null != file2 && file2.exists() && file2.canRead()) {
                    try {
                        this.doIndicateJar(file2, file);
                        continue;
                    }
                    catch (DiagnosticDataAccessException diagnosticDataAccessException) {
                        this.fLogger.error((Object)("Error during indication of zip file " + file2), (Throwable)diagnosticDataAccessException);
                        throw this.buildException(diagnosticDataAccessException);
                    }
                }
                this.fLogger.error((Object)("Error accesing zip file " + datei.getValue() + ". Pathname should be " + string2 + File.separator + datei.getValue()));
                throw new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.PATH_NOT_FOUND_OR_READABLE);
            }
        }
    }

    private DiagnosticDataIndicationException buildException(DiagnosticDataAccessException diagnosticDataAccessException) {
        DiagnosticDataIndicationException diagnosticDataIndicationException = null != diagnosticDataAccessException.getCause() ? (diagnosticDataAccessException.getCause() instanceof InvalidDigestException || diagnosticDataAccessException.getCause() instanceof SignatureException ? new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.SIG_CHECK_FAILED, diagnosticDataAccessException.getCause()) : new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.PATH_NOT_FOUND_OR_READABLE, diagnosticDataAccessException.getCause())) : new DiagnosticDataIndicationException(DiagnosticDataIndicationException.ErrorId.PATH_NOT_FOUND_OR_READABLE);
        return diagnosticDataIndicationException;
    }

    private void doIndicateJar(File file, File file2) throws DiagnosticDataAccessException {
        Object object = DiagnosticDataAccessHelper.parseFileFromJar(file, "index.xml", VAUDESTeilpaket.class);
        if (object instanceof VAUDESTeilpaket) {
            VAUDESTeilpaket vAUDESTeilpaket = (VAUDESTeilpaket)object;
            this.indicateTeilpaket(vAUDESTeilpaket, file, file2);
        } else {
            this.fLogger.error((Object)("Failed to indicate file " + file + ". No teilpaket found."));
        }
    }

    public void clearIndex() {
        this.fObjectIdIndex.clear();
        this.fSystemNameIndex.clear();
        FunctiontestIndicator.getInstance().clearIndex();
    }

    public Map<String, IndicatedElement> getObjectIndex() {
        return this.fObjectIdIndex;
    }

    private Map<String, IndicatedElement> getRuntimeObjectIndex() {
        return this.fRuntimeObjectIdIndex;
    }

    private Map<String, IndicatedElement> getRuntimeSystemNameIndex() {
        return this.fRuntimeSystemNameIndex;
    }

    public boolean contains(String string) {
        boolean bl;
        boolean bl2 = bl = this.getObjectIndex().containsKey(string) || this.getSystemNameIndex().containsKey(string);
        if (!bl) {
            String string2 = this.convert(string);
            bl = this.getObjectIndex().containsKey(string2) || this.getSystemNameIndex().containsKey(string2);
        }
        return bl;
    }

    private Map<String, IndicatedElement> getSystemNameIndex() {
        return this.fSystemNameIndex;
    }

    public void setBaselineVersion(String string) {
        this.fBaselineVersion = string;
    }

    public String getBaselineVersion() {
        return this.fBaselineVersion;
    }

    public Map<String, IndicatedElement> getTemporaryObjectIndex() {
        return this.fTemporaryObjectIndex;
    }

    public String getTestbaselineVersion() {
        return this.fTestbaselineVersion;
    }

    public void setTestbaselineVersion(String string) {
        this.fTestbaselineVersion = string;
    }

    public void setBrand(String string) {
        this.fBrand = string;
    }

    public String getBrand() {
        return this.fBrand;
    }

    private String convert(String string) {
        String string2 = string;
        if (string.toLowerCase().equals(TextquelleDOM.ALLGSYSTEMTEXTE.value())) {
            string2 = "AllgSystemtexte";
        } else if (string.toLowerCase().equals(TextquelleDOM.DOKKATTEXTE.value())) {
            string2 = "Dokkattexte";
        } else if (string.toLowerCase().equals(TextquelleDOM.FAHRZEUGZUSTANDSTEXTE.value())) {
            string2 = "Fahrzeugzustandstexte";
        } else if (string.toLowerCase().equals(TextquelleDOM.STANDARDTEXTE.value())) {
            string2 = "Standardtexte";
        }
        return string2;
    }

    public void setTestbaselineMode(boolean bl) {
        this.fTblMode = bl;
    }

    public boolean isTblMode() {
        return this.fTblMode;
    }

    public void reset() {
        this.setBaselineVersion(null);
        this.setTestbaselineVersion(null);
        this.setBrand(null);
        this.setTestbaselineMode(false);
    }
}

