/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.transform;

import de.volkswagen.odis.vaudas.core.exception.OdisBaseException;
import de.volkswagen.odis.vaudas.core.exception.ids.Topology;
import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITextId;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.dto.HookDocumentInheritanceWrapper;
import de.vw.vaudes.diaghook.dto.HookTextIdWrapper;
import de.vw.vaudes.xml.object.BildformatDOM;
import de.vw.vaudes.xml.object.Diagnoseobjekt;
import de.vw.vaudes.xml.object.Fehlerausdruck;
import de.vw.vaudes.xml.object.ParaStringTYPE;
import de.vw.vaudes.xml.object.StringRef;
import de.vw.vaudes.xml.object.TextformatDOM;
import de.vw.vaudes.xml.object.TextquelleDOM;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import de.vw.vaudes.xml.object.Variantenregel;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DbgHookTransformHelper {
    private static final Log LOG = LogFactory.getLog(DbgHookTransformHelper.class);
    private static Marshaller fVObjMarshaller;
    private static boolean fIsInitialized;

    private DbgHookTransformHelper() {
    }

    private static void initJaxB() {
        if (!fIsInitialized) {
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{VAUDESObjekt.class});
                fVObjMarshaller = jAXBContext.createMarshaller();
                fVObjMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
                fIsInitialized = true;
            }
            catch (JAXBException jAXBException) {
                LOG.error((Object)"Error initializing JAXB", (Throwable)jAXBException);
            }
        }
    }

    public static List<HookDocumentInheritanceWrapper> getAllDocumentInheritanceReferencesFrom(VAUDESObjekt vAUDESObjekt) {
        ArrayList<HookDocumentInheritanceWrapper> arrayList = new ArrayList<HookDocumentInheritanceWrapper>();
        if (null == vAUDESObjekt.getDiagnoseobjekt()) {
            LOG.warn((Object)"Attempt to transform a non-diagnostic object to a diagnostic object");
            return arrayList;
        }
        if (null == vAUDESObjekt.getDiagnoseobjekt().getHatDokumentationsverweise()) {
            return arrayList;
        }
        for (Diagnoseobjekt.HatDokumentationsverweise.Verweis verweis : vAUDESObjekt.getDiagnoseobjekt().getHatDokumentationsverweise().getVerweis()) {
            if (null == verweis.getVererbung()) continue;
            try {
                ParaStringTYPE.DocRef.Vererbung vererbung = verweis.getVererbung();
                HookDocumentInheritanceWrapper hookDocumentInheritanceWrapper = new HookDocumentInheritanceWrapper();
                hookDocumentInheritanceWrapper.setDiagObjectKey(vAUDESObjekt.getId());
                hookDocumentInheritanceWrapper.setDirection(DbgHookTransformHelper.getInheritanceDirectionFrom(vererbung));
                hookDocumentInheritanceWrapper.setDirection(vererbung.getRichtung());
                if (null != verweis.getDokumentkategorie()) {
                    hookDocumentInheritanceWrapper.setDocCategory(DbgHookTransformHelper.transformDocumentCategoryFrom(verweis.getDokumentkategorie()));
                    hookDocumentInheritanceWrapper.setDocCategory(verweis.getDokumentkategorie());
                }
                if (null != verweis.getVariantenregel()) {
                    hookDocumentInheritanceWrapper.setVariantRule(DbgHookTransformHelper.transformVariantRule(verweis.getVariantenregel()));
                }
                arrayList.add(hookDocumentInheritanceWrapper);
            }
            catch (Exception exception) {
                LOG.error((Object)("Error while parsing object with id " + verweis), (Throwable)exception);
            }
        }
        return arrayList;
    }

    public static int transformDocumentCategoryFrom(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("Bauteilbeschreibung")) {
            n = 1;
        } else if (string.equalsIgnoreCase("Blockschaltbild")) {
            n = 2;
        } else if (string.equalsIgnoreCase("Codiertabelle")) {
            n = 3;
        } else if (string.equalsIgnoreCase("Einbauort")) {
            n = 4;
        } else if (string.equalsIgnoreCase("Einstellanleitung")) {
            n = 5;
        } else if (string.equalsIgnoreCase("Funktionsbeschreibung")) {
            n = 6;
        } else if (string.equalsIgnoreCase("Funktionspruefanleitung")) {
            n = 7;
        } else if (string.equalsIgnoreCase("Messmittel")) {
            n = 8;
        } else if (string.equalsIgnoreCase("Pinbelegung")) {
            n = 9;
        } else if (string.equalsIgnoreCase("Reparaturanleitung")) {
            n = 10;
        } else if (string.equalsIgnoreCase("Reparaturleitfaden")) {
            n = 11;
        } else if (string.equalsIgnoreCase("Sicherungsbelegung")) {
            n = 12;
        } else if (string.equalsIgnoreCase("Sollwerte")) {
            n = 13;
        } else if (string.equalsIgnoreCase("Steckeransicht")) {
            n = 14;
        } else if (string.equalsIgnoreCase("Stromlaufplan")) {
            n = 15;
        } else if (string.equalsIgnoreCase("Systembeschreibung")) {
            n = 16;
        } else if (string.equalsIgnoreCase("Systemschaltplan")) {
            n = 17;
        } else if (string.equalsIgnoreCase("TechnischeProblemloesung")) {
            n = 18;
        } else if (string.equalsIgnoreCase("Werkzeuge")) {
            n = 19;
        } else if (string.equalsIgnoreCase("Zeichnung")) {
            n = 20;
        } else if (string.equalsIgnoreCase("Vernetzungsplan")) {
            n = 21;
        } else if (string.equalsIgnoreCase("interaktiverStromlaufplan")) {
            n = 22;
        }
        return n;
    }

    private static int getInheritanceDirectionFrom(ParaStringTYPE.DocRef.Vererbung vererbung) {
        int n = 0;
        String string = vererbung.getRichtung();
        if (string.equalsIgnoreCase("ErbenVomVorgaenger")) {
            n = 1;
        } else if (string.equalsIgnoreCase("ErbenVomNachfolger")) {
            n = 2;
        }
        return n;
    }

    public static String transformFaultExpression(Fehlerausdruck fehlerausdruck) {
        String string = "";
        DbgHookTransformHelper.initJaxB();
        try {
            StringWriter stringWriter = new StringWriter();
            fVObjMarshaller.marshal((Object)fehlerausdruck, (Writer)stringWriter);
            string = stringWriter.toString();
        }
        catch (Exception exception) {
            LOG.error((Object)"error marshalling fehlerausdruck xml", (Throwable)exception);
        }
        return string;
    }

    public static String transformVariantRule(Variantenregel variantenregel) {
        String string = "";
        DbgHookTransformHelper.initJaxB();
        try {
            StringWriter stringWriter = new StringWriter();
            fVObjMarshaller.marshal((Object)variantenregel, (Writer)stringWriter);
            string = stringWriter.toString();
        }
        catch (Exception exception) {
            LOG.error((Object)"error marshalling variant rule xml", (Throwable)exception);
        }
        return string;
    }

    public static OdisBaseException createOdisBaseException(String string) {
        return new OdisBaseException("Object/Requestparameter " + string + " not found.", Topology.database().dbReadFailed());
    }

    public static ITextId createTextIdFrom(String string, StringRef stringRef) {
        HookTextIdWrapper hookTextIdWrapper = new HookTextIdWrapper();
        hookTextIdWrapper.setId(stringRef.getIdRef());
        if (stringRef.getStringquelle().equals((Object)TextquelleDOM.OBJEKT)) {
            if (null != stringRef.getObjektRef()) {
                hookTextIdWrapper.setSource(stringRef.getObjektRef());
            } else {
                hookTextIdWrapper.setSource(string);
            }
        } else if (stringRef.getStringquelle().equals((Object)TextquelleDOM.EFATEXTE)) {
            hookTextIdWrapper.setSource("EfaCodes");
        } else {
            hookTextIdWrapper.setSource(stringRef.getStringquelle().value());
        }
        return hookTextIdWrapper;
    }

    public static ITextId createTextIdFrom(String string, String string2) {
        HookTextIdWrapper hookTextIdWrapper = new HookTextIdWrapper();
        hookTextIdWrapper.setId(string2);
        hookTextIdWrapper.setSource(string);
        return hookTextIdWrapper;
    }

    public static int transformDocumentFormat(String string) {
        int n = 0;
        if (string.equalsIgnoreCase(TextformatDOM.HTML.toString())) {
            n = 6;
        } else if (string.equalsIgnoreCase(TextformatDOM.HTML_WITH_REPLACEMENTS.toString())) {
            n = 7;
        } else if (string.equalsIgnoreCase(BildformatDOM.PNG.toString())) {
            n = 2;
        } else if (string.equalsIgnoreCase(BildformatDOM.SVG.toString())) {
            n = 4;
        }
        return n;
    }

    public static String extractCreationSiteFromSystemname(String string) {
        if (StringUtils.contains((String)string, (char)'@')) {
            return StringUtils.substringAfterLast((String)string, (String)"@");
        }
        return "00000";
    }

    public static OdisBaseException createOdisBaseException(NonUniqueResultException nonUniqueResultException) {
        LOG.warn((Object)nonUniqueResultException);
        return new OdisBaseException("Can't deliver data for non unique System Name: " + nonUniqueResultException.getSystemName(), Topology.diagnosticDataHook().ambiguousSystemName());
    }

    static {
        fIsInitialized = false;
    }
}

