/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.transform;

import de.volkswagen.odis.vaudas.domainmodel.efa.bean.IEfaErrorType;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IDocumentLink;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IHotSpot;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.dto.HookDocumentLinkWrapper;
import de.vw.vaudes.diaghook.dto.HookHotspotWrapper;
import de.vw.vaudes.diaghook.factory.OverlayingFactoryObjectResolver;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.transform.EfaTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.xml.object.Diagnoseobjekt;
import de.vw.vaudes.xml.object.EfaFehlerObjektTYPE;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import de.vw.vaudes.xml.object.Zusatzdokument;
import de.vw.vaudes.xml.object.ZusatzdokumentDOM;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DocumentTransformHelper {
    private static final Log LOG = LogFactory.getLog(DocumentTransformHelper.class);

    private DocumentTransformHelper() {
    }

    public static boolean transformSupplementaryDocument(IDocumentLink iDocumentLink, VAUDESObjekt vAUDESObjekt) throws NonUniqueResultException {
        boolean bl = false;
        if (null == vAUDESObjekt.getZusatzdokument()) {
            LOG.warn((Object)"Attempt to transform a non-document object to a document object");
        } else {
            iDocumentLink.setDocCategory(DbgHookTransformHelper.transformDocumentCategoryFrom(vAUDESObjekt.getZusatzdokument().getDokumentkategorie()));
            if (vAUDESObjekt.getZusatzdokument().getTextOrBild().size() == 1) {
                Object object = vAUDESObjekt.getZusatzdokument().getTextOrBild().get(0);
                if (object instanceof Zusatzdokument.Bild) {
                    Zusatzdokument.Bild bild = (Zusatzdokument.Bild)object;
                    iDocumentLink.setDocFormat(DbgHookTransformHelper.transformDocumentFormat(bild.getFormat().toString()));
                    iDocumentLink.setIdOrURI(DiagnosticDataAccessHelper.getFilenameFromObject(vAUDESObjekt, bild.getDatei().getDateiRef()));
                    iDocumentLink.getHotSpots().addAll(DocumentTransformHelper.transformHotspots(vAUDESObjekt));
                } else {
                    Zusatzdokument.Text text = (Zusatzdokument.Text)object;
                    iDocumentLink.setDocFormat(DbgHookTransformHelper.transformDocumentFormat(text.getFormat().toString()));
                    iDocumentLink.setIdOrURI(DiagnosticDataAccessHelper.getFilenameFromObject(vAUDESObjekt, text.getDatei().getDateiRef()));
                }
            } else {
                for (Object object : vAUDESObjekt.getZusatzdokument().getTextOrBild()) {
                    if (!(object instanceof Zusatzdokument.Bild)) continue;
                    iDocumentLink.setDocFormat(DbgHookTransformHelper.transformDocumentFormat(((Zusatzdokument.Bild)object).getFormat().toString()));
                    iDocumentLink.setIdOrURI(DiagnosticDataAccessHelper.getFilenameFromObject(vAUDESObjekt, ((Zusatzdokument.Bild)object).getDatei().getDateiRef()));
                    iDocumentLink.getHotSpots().addAll(DocumentTransformHelper.transformHotspots(vAUDESObjekt));
                    break;
                }
            }
            if (null != vAUDESObjekt.getAnzeigename()) {
                iDocumentLink.setDocName(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), vAUDESObjekt.getAnzeigename().getStringRef()));
            }
            iDocumentLink.setDoNotPrintHeaderInfo(vAUDESObjekt.getZusatzdokument().isDruckenOhneHeader());
            iDocumentLink.setDocumentLinkKey(vAUDESObjekt.getSystemname());
            iDocumentLink.setSourceSystem("lokal");
            iDocumentLink.setVaudesObjectId(vAUDESObjekt.getId());
            bl = true;
        }
        return bl;
    }

    public static IDocumentLink createSupplementaryDocument(VAUDESObjekt vAUDESObjekt) throws NonUniqueResultException {
        HookDocumentLinkWrapper hookDocumentLinkWrapper = null;
        HookDocumentLinkWrapper hookDocumentLinkWrapper2 = new HookDocumentLinkWrapper();
        if (DocumentTransformHelper.transformSupplementaryDocument(hookDocumentLinkWrapper2, vAUDESObjekt)) {
            hookDocumentLinkWrapper = hookDocumentLinkWrapper2;
        }
        return hookDocumentLinkWrapper;
    }

    public static List<IDocumentLink> transformSupplementaryDocumentFromDiagObject(VAUDESObjekt vAUDESObjekt) throws NonUniqueResultException {
        ArrayList<IDocumentLink> arrayList = new ArrayList<IDocumentLink>();
        if (null == vAUDESObjekt.getDiagnoseobjekt()) {
            LOG.warn((Object)"Attempt to transform document links from a non-diagnostic object");
            return arrayList;
        }
        if (null == vAUDESObjekt.getDiagnoseobjekt().getHatDokumentationsverweise()) {
            return arrayList;
        }
        for (Diagnoseobjekt.HatDokumentationsverweise.Verweis verweis : vAUDESObjekt.getDiagnoseobjekt().getHatDokumentationsverweise().getVerweis()) {
            Object object = new HookDocumentLinkWrapper();
            if (null != verweis.getDokumentkategorie()) {
                object.setDocCategory(DbgHookTransformHelper.transformDocumentCategoryFrom(verweis.getDokumentkategorie()));
            }
            if (null != verweis.getIntern()) {
                VAUDESObjekt vAUDESObjekt2;
                object.setSourceSystem("lokal");
                Object object2 = DiagnosticDataAccessHelper.parseFile(verweis.getIntern().getObjektRef(), VAUDESObjekt.class);
                if (object2 instanceof VAUDESObjekt) {
                    vAUDESObjekt2 = (VAUDESObjekt)object2;
                    object.setDocumentLinkKey(vAUDESObjekt2.getSystemname());
                    if (null != vAUDESObjekt2.getZusatzdokument()) {
                        if (null != vAUDESObjekt2.getAnzeigename()) {
                            object.setDocName(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt2.getId(), vAUDESObjekt2.getAnzeigename().getStringRef()));
                        }
                        if (vAUDESObjekt2.getZusatzdokument().getTyp().equals((Object)ZusatzdokumentDOM.TEXT_MIT_BILD)) {
                            for (Object object3 : vAUDESObjekt2.getZusatzdokument().getTextOrBild()) {
                                if (object3 instanceof Zusatzdokument.Bild) {
                                    object.setIdOrURI(DiagnosticDataAccessHelper.getFilenameFromObject(vAUDESObjekt2, ((Zusatzdokument.Bild)object3).getDatei().getDateiRef()));
                                    object.getHotSpots().addAll(DocumentTransformHelper.transformHotspots(vAUDESObjekt2));
                                    continue;
                                }
                                if (!(object3 instanceof Zusatzdokument.Text)) continue;
                                Zusatzdokument.Text text = (Zusatzdokument.Text)object3;
                                HookDocumentLinkWrapper hookDocumentLinkWrapper = new HookDocumentLinkWrapper();
                                hookDocumentLinkWrapper.setDocCategory(DbgHookTransformHelper.transformDocumentCategoryFrom(vAUDESObjekt2.getZusatzdokument().getDokumentkategorie()));
                                hookDocumentLinkWrapper.setDocFormat(DbgHookTransformHelper.transformDocumentFormat(text.getFormat().toString()));
                                if (null != vAUDESObjekt2.getAnzeigename()) {
                                    hookDocumentLinkWrapper.setDocName(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt2.getId(), vAUDESObjekt2.getAnzeigename().getStringRef()));
                                }
                                hookDocumentLinkWrapper.setDocumentLinkKey(vAUDESObjekt2.getSystemname());
                                hookDocumentLinkWrapper.setIdOrURI(DiagnosticDataAccessHelper.getFilenameFromObject(vAUDESObjekt2, text.getDatei().getDateiRef()));
                                hookDocumentLinkWrapper.setVaudesObjectId(vAUDESObjekt2.getId());
                                hookDocumentLinkWrapper.setSourceSystem("lokal");
                                hookDocumentLinkWrapper.setDoNotPrintHeaderInfo(object.isDoNotPrintHeaderInfo());
                                object.getParallelDocs().add(hookDocumentLinkWrapper);
                            }
                        } else if (vAUDESObjekt2.getZusatzdokument().getTyp().equals((Object)ZusatzdokumentDOM.BILD)) {
                            int n = DbgHookTransformHelper.transformDocumentFormat(((Zusatzdokument.Bild)vAUDESObjekt2.getZusatzdokument().getTextOrBild().get(0)).getFormat().toString());
                            object.setIdOrURI(DiagnosticDataAccessHelper.getFilenameFromObject(vAUDESObjekt2, ((Zusatzdokument.Bild)vAUDESObjekt2.getZusatzdokument().getTextOrBild().get(0)).getDatei().getDateiRef()));
                            object.setDocFormat(n);
                        } else {
                            int n = DbgHookTransformHelper.transformDocumentFormat(((Zusatzdokument.Text)vAUDESObjekt2.getZusatzdokument().getTextOrBild().get(0)).getFormat().toString());
                            object.setIdOrURI(DiagnosticDataAccessHelper.getFilenameFromObject(vAUDESObjekt2, ((Zusatzdokument.Text)vAUDESObjekt2.getZusatzdokument().getTextOrBild().get(0)).getDatei().getDateiRef()));
                            object.setDocFormat(n);
                        }
                        object.setDoNotPrintHeaderInfo(vAUDESObjekt2.getZusatzdokument().isDruckenOhneHeader());
                    }
                    object.setVaudesObjectId(vAUDESObjekt2.getId());
                } else {
                    LOG.warn((Object)("Referenced document object not found in index: " + verweis.getIntern().getObjektRef()));
                    vAUDESObjekt2 = OverlayingFactoryObjectResolver.getInstance().getDoclink(verweis.getIntern().getObjektRef());
                    if (null == vAUDESObjekt2) continue;
                    object = vAUDESObjekt2;
                }
            } else if (null != verweis.getExtern()) {
                object.setSourceSystem("VAUDAS_generated_" + verweis.getExtern().getZielsystem().name() + "_" + verweis.getExtern().getValue());
                object.setIdOrURI(verweis.getExtern().getValue());
            } else if (null != verweis.getEfaFehlerObjekt()) {
                object.setDocCategory(0);
                object.setDocFormat(0);
                object.setDocumentLinkKey("EfaCodes");
                object.setIdOrURI("EfaCodes");
                object.setSourceSystem("lokal");
                object.setVaudesObjectId("EfaCodes");
            }
            arrayList.add((IDocumentLink)object);
        }
        return arrayList;
    }

    public static List<IHotSpot> transformHotspots(VAUDESObjekt vAUDESObjekt) throws NonUniqueResultException {
        ArrayList<IHotSpot> arrayList = new ArrayList<IHotSpot>();
        if (null == vAUDESObjekt.getZusatzdokument()) {
            LOG.warn((Object)"Attempt to get hotspots from a non-supplementary document object");
            return arrayList;
        }
        for (Object object : vAUDESObjekt.getZusatzdokument().getTextOrBild()) {
            if (!(object instanceof Zusatzdokument.Bild)) continue;
            Zusatzdokument.Bild bild = (Zusatzdokument.Bild)object;
            if (!bild.getHotspot().isEmpty()) {
                int n = 0;
                for (Zusatzdokument.Bild.Hotspot hotspot : bild.getHotspot()) {
                    HookDocumentLinkWrapper hookDocumentLinkWrapper;
                    Object object2;
                    HookHotspotWrapper hookHotspotWrapper = new HookHotspotWrapper();
                    if (null != hotspot.getIntern()) {
                        hookHotspotWrapper.setChildDocumentLinkKey(hotspot.getIntern().getObjektRef());
                        object2 = DiagnosticDataAccessHelper.parseFile(hotspot.getIntern().getObjektRef(), VAUDESObjekt.class);
                        if (object2 instanceof VAUDESObjekt) {
                            hookHotspotWrapper.setDocLink(DocumentTransformHelper.createSupplementaryDocument((VAUDESObjekt)object2));
                            hookHotspotWrapper.setChildDocumentLinkKey(((VAUDESObjekt)object2).getId());
                        } else {
                            hookDocumentLinkWrapper = OverlayingFactoryObjectResolver.getInstance().getDoclink(hotspot.getIntern().getObjektRef());
                            if (null != hookDocumentLinkWrapper) {
                                hookHotspotWrapper.setDocLink(hookDocumentLinkWrapper);
                                hookHotspotWrapper.setChildDocumentLinkKey(hotspot.getIntern().getObjektRef());
                            }
                        }
                    } else if (null != hotspot.getIndirektDO()) {
                        hookHotspotWrapper.setChildDocumentLinkKey(hotspot.getIndirektDO().getObjektRef());
                        object2 = DiagnosticDataAccessHelper.parseFile(hotspot.getIndirektDO().getObjektRef(), VAUDESObjekt.class);
                        if (object2 instanceof VAUDESObjekt) {
                            hookHotspotWrapper.setDocLink(DocumentTransformHelper.createSupplementaryDocument((VAUDESObjekt)object2));
                            hookHotspotWrapper.setChildDocumentLinkKey(((VAUDESObjekt)object2).getId());
                        } else {
                            hookDocumentLinkWrapper = OverlayingFactoryObjectResolver.getInstance().getDoclink(hotspot.getIndirektDO().getObjektRef());
                            if (null != hookDocumentLinkWrapper) {
                                hookHotspotWrapper.setDocLink(hookDocumentLinkWrapper);
                                hookHotspotWrapper.setChildDocumentLinkKey(hotspot.getIndirektDO().getObjektRef());
                            }
                        }
                    } else if (null != hotspot.getExtern()) {
                        hookHotspotWrapper.setChildDocumentLinkKey("VAUDAS_generated_" + hotspot.getExtern().getZielsystem().name() + "_" + hotspot.getExtern().getValue());
                        object2 = new HookDocumentLinkWrapper();
                        if (null != hotspot.getDokumentkategorie()) {
                            ((HookDocumentLinkWrapper)object2).setDocCategory(DbgHookTransformHelper.transformDocumentCategoryFrom(hotspot.getDokumentkategorie()));
                        }
                        ((HookDocumentLinkWrapper)object2).setDocFormat(DbgHookTransformHelper.transformDocumentFormat(bild.getFormat().toString()));
                        ((HookDocumentLinkWrapper)object2).setDocumentLinkKey("VAUDAS_generated_" + hotspot.getExtern().getZielsystem().name() + "_" + hotspot.getExtern().getValue());
                        ((HookDocumentLinkWrapper)object2).setIdOrURI(hotspot.getExtern().getValue());
                        ((HookDocumentLinkWrapper)object2).setSourceSystem(hotspot.getExtern().getZielsystem().name());
                        hookHotspotWrapper.setDocLink((IDocumentLink)object2);
                    } else if (null != hotspot.getEfaFehlerObjekt()) {
                        object2 = hotspot.getEfaFehlerObjekt();
                        hookDocumentLinkWrapper = new HookDocumentLinkWrapper();
                        if (null != hotspot.getDokumentkategorie()) {
                            hookDocumentLinkWrapper.setDocCategory(DbgHookTransformHelper.transformDocumentCategoryFrom(hotspot.getDokumentkategorie()));
                        } else {
                            hookDocumentLinkWrapper.setDocCategory(0);
                        }
                        hookDocumentLinkWrapper.setDocFormat(DbgHookTransformHelper.transformDocumentFormat(bild.getFormat().toString()));
                        Object object3 = DiagnosticDataAccessHelper.parseFile("EfaCodes", VAUDESObjekt.class);
                        if (object3 instanceof VAUDESObjekt) {
                            VAUDESObjekt vAUDESObjekt2 = (VAUDESObjekt)object3;
                            IEfaErrorType iEfaErrorType = EfaTransformHelper.getEfaErrorTypeForId(((EfaFehlerObjektTYPE)object2).getId());
                            if (null != iEfaErrorType) {
                                hookDocumentLinkWrapper.setDocName(iEfaErrorType.getErrorTypeTitle());
                            } else if (vAUDESObjekt2.getAnzeigename() != null) {
                                hookDocumentLinkWrapper.setDocName(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt2.getId(), vAUDESObjekt2.getAnzeigename().getStringRef()));
                            }
                        }
                        hookDocumentLinkWrapper.setSourceSystem("lokal");
                        hookDocumentLinkWrapper.setIdOrURI(String.valueOf("EfaCodes"));
                        hookDocumentLinkWrapper.setVaudesObjectId("EfaCodes");
                        hookDocumentLinkWrapper.setDocumentLinkKey("EfaCodes");
                        hookHotspotWrapper.setDocLink(hookDocumentLinkWrapper);
                    }
                    hookHotspotWrapper.setHeight(hotspot.getH().intValue());
                    hookHotspotWrapper.setHotSpotNr(n);
                    hookHotspotWrapper.setParentDocumentLinkKey(vAUDESObjekt.getSystemname());
                    hookHotspotWrapper.setPosX(hotspot.getX().intValue());
                    hookHotspotWrapper.setPosY(hotspot.getY().intValue());
                    hookHotspotWrapper.setWidth(hotspot.getW().intValue());
                    arrayList.add(hookHotspotWrapper);
                    ++n;
                }
                continue;
            }
            LOG.warn((Object)("Object with id " + vAUDESObjekt.getId() + " contains no hotspots"));
        }
        return arrayList;
    }

    public static List<IDocumentLink> getParallelDocLinks(VAUDESObjekt vAUDESObjekt) {
        ArrayList<IDocumentLink> arrayList = new ArrayList<IDocumentLink>();
        if (null == vAUDESObjekt.getZusatzdokument()) {
            LOG.warn((Object)"Attempt to transform hotspots from a non-supplementary document object");
            return arrayList;
        }
        if (vAUDESObjekt.getZusatzdokument().getTyp().equals((Object)ZusatzdokumentDOM.TEXT_MIT_BILD)) {
            for (Object object : vAUDESObjekt.getZusatzdokument().getTextOrBild()) {
                if (!(object instanceof Zusatzdokument.Text)) continue;
                Zusatzdokument.Text text = (Zusatzdokument.Text)object;
                HookDocumentLinkWrapper hookDocumentLinkWrapper = new HookDocumentLinkWrapper();
                hookDocumentLinkWrapper.setDocCategory(DbgHookTransformHelper.transformDocumentCategoryFrom(vAUDESObjekt.getZusatzdokument().getDokumentkategorie()));
                hookDocumentLinkWrapper.setDocFormat(DbgHookTransformHelper.transformDocumentFormat(text.getFormat().toString()));
                if (null != vAUDESObjekt.getAnzeigename()) {
                    hookDocumentLinkWrapper.setDocName(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), vAUDESObjekt.getAnzeigename().getStringRef()));
                }
                hookDocumentLinkWrapper.setDocumentLinkKey(vAUDESObjekt.getSystemname());
                hookDocumentLinkWrapper.setIdOrURI(DiagnosticDataAccessHelper.getFilenameFromObject(vAUDESObjekt, text.getDatei().getDateiRef()));
                hookDocumentLinkWrapper.setSourceSystem("lokal");
                hookDocumentLinkWrapper.setVaudesObjectId(vAUDESObjekt.getId());
                hookDocumentLinkWrapper.setDoNotPrintHeaderInfo(vAUDESObjekt.getZusatzdokument().isDruckenOhneHeader());
                arrayList.add(hookDocumentLinkWrapper);
            }
        }
        return arrayList;
    }

    public static void adjustDocumentLinks(IDocumentLink iDocumentLink, IDocumentLink iDocumentLink2) {
        iDocumentLink.setDocCategory(iDocumentLink2.getDocCategory());
        iDocumentLink.setDocFormat(iDocumentLink2.getDocFormat());
        iDocumentLink.setDocName(iDocumentLink2.getDocName());
        iDocumentLink.setDocumentLinkKey(iDocumentLink2.getDocumentLinkKey());
        iDocumentLink.setIdOrURI(iDocumentLink2.getIdOrURI());
        iDocumentLink.setSourceSystem(iDocumentLink2.getSourceSystem());
        iDocumentLink.setVaudesObjectId(iDocumentLink2.getVaudesObjectId());
        iDocumentLink.getHotSpots().clear();
        iDocumentLink.getHotSpots().addAll(iDocumentLink2.getHotSpots());
        iDocumentLink.setDoNotPrintHeaderInfo(iDocumentLink2.isDoNotPrintHeaderInfo());
    }

    public static void adjustHotSpotObjects(IHotSpot iHotSpot, IHotSpot iHotSpot2) {
        iHotSpot.setChildDocumentLinkKey(iHotSpot2.getChildDocumentLinkKey());
        iHotSpot.setHeight(iHotSpot2.getHeight());
        iHotSpot.setHotSpotNr(iHotSpot2.getHotSpotNr());
        iHotSpot.setParentDocumentLinkKey(iHotSpot2.getParentDocumentLinkKey());
        iHotSpot.setPosX(iHotSpot2.getPosX());
        iHotSpot.setPosY(iHotSpot2.getPosY());
        iHotSpot.setWidth(iHotSpot2.getWidth());
    }
}

