/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.transform;

import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITextId;
import de.volkswagen.odis.vaudas.domainmodel.base.bean.ITranslatedText;
import de.vw.vaudes.diaghook.cache.TextCache;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.dto.HookTextIdWrapper;
import de.vw.vaudes.diaghook.dto.HookTranslatedTextWrapper;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.db.DatabaseResolver;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataHookConstants;
import de.vw.vaudes.diaghook.util.JaxbUtils;
import de.vw.vaudes.diaghook.util.Pair;
import de.vw.vaudes.xml.instpackage.TeilpaketTYPE;
import de.vw.vaudes.xml.instpackage.VAUDESInstallationspaket;
import de.vw.vaudes.xml.object.InhaltdateiDOM;
import de.vw.vaudes.xml.object.TextquelleDOM;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import de.vw.vaudes.xml.partpackage.ObjektdateiDOM;
import de.vw.vaudes.xml.partpackage.VAUDESTeilpaket;
import de.vw.vaudes.xml.stringtable.String;
import de.vw.vaudes.xml.stringtable.VAUDESStringTabelle;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TranslatedTextTransformHelper {
    private static final Log LOGGER = LogFactory.getLog(TranslatedTextTransformHelper.class);
    private static boolean isInitialized = false;
    private static JAXBContext fJAXBContext;
    private static Locale FALLBACK_LOCALE;

    private TranslatedTextTransformHelper() {
    }

    private static void initJaxB() {
        if (!isInitialized) {
            try {
                fJAXBContext = JAXBContext.newInstance((Class[])new Class[]{String.class});
                isInitialized = true;
            }
            catch (JAXBException jAXBException) {
                LOGGER.error((Object)"Error initializing JAXB", (Throwable)jAXBException);
            }
        }
    }

    public static ITranslatedText getTranslatedTextFrom(IndicatedElement indicatedElement, Locale locale, ITextId iTextId) {
        HookTranslatedTextWrapper hookTranslatedTextWrapper = null;
        Object object = DiagnosticDataAccessHelper.parseFile(indicatedElement, VAUDESObjekt.class);
        if (!(object instanceof VAUDESObjekt)) {
            return hookTranslatedTextWrapper;
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        if (null == vAUDESObjekt.getDateien()) {
            return hookTranslatedTextWrapper;
        }
        List<VAUDESObjekt.Dateien.Datei> list = TranslatedTextTransformHelper.getAllTranslatableTextFilesFrom(vAUDESObjekt);
        boolean bl = false;
        for (VAUDESObjekt.Dateien.Datei datei : list) {
            Object object2;
            Object object3 = null;
            try {
                if (null != indicatedElement.getInstallationIndexFile()) {
                    object2 = locale;
                    if (ObjectIndicator.getInstance().isTblMode()) {
                        object2 = FALLBACK_LOCALE;
                    }
                    object3 = DiagnosticDataAccessHelper.getLanguageDependentContentFileFromHotfix(indicatedElement.getInstallationIndexFile(), datei, (Locale)object2, VAUDESStringTabelle.class);
                } else {
                    object2 = DiagnosticDataAccessHelper.getContentFileFromObject(indicatedElement, datei.getValue(), VAUDESStringTabelle.class);
                    if (object2 instanceof VAUDESStringTabelle && TranslatedTextTransformHelper.isLocaleEqual(((VAUDESStringTabelle)object2).getSprache(), locale)) {
                        object3 = object2;
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception);
            }
            if (!(object3 instanceof VAUDESStringTabelle) || null == ((VAUDESStringTabelle)(object2 = (VAUDESStringTabelle)object3)).getString()) continue;
            for (String string : ((VAUDESStringTabelle)object2).getString()) {
                if (!string.getId().equalsIgnoreCase(iTextId.getId())) continue;
                hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
                if (!ObjectIndicator.getInstance().isTblMode()) {
                    hookTranslatedTextWrapper.setLanguage(StringUtils.replaceChars((java.lang.String)((VAUDESStringTabelle)object2).getSprache(), (char)'-', (char)'_'));
                } else {
                    hookTranslatedTextWrapper.setLanguage("od_OD");
                }
                hookTranslatedTextWrapper.setText(TranslatedTextTransformHelper.transformTextContent(string));
                hookTranslatedTextWrapper.setTextId(iTextId.getId());
                hookTranslatedTextWrapper.setTextSource(iTextId.getSource());
                bl = true;
                break;
            }
            if (!bl) continue;
            break;
        }
        return hookTranslatedTextWrapper;
    }

    public static java.lang.String transformTextContent(String string) {
        java.lang.String string2 = "";
        TranslatedTextTransformHelper.initJaxB();
        try {
            Marshaller marshaller = fJAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)string, (Writer)stringWriter);
            string2 = stringWriter.toString();
        }
        catch (Exception exception) {
            LOGGER.error((Object)"error marshalling text content xml", (Throwable)exception);
        }
        return string2;
    }

    public static List<ITranslatedText> getTranslatedTextsFrom(IndicatedElement indicatedElement, Locale locale) {
        ArrayList<ITranslatedText> arrayList = new ArrayList<ITranslatedText>();
        if (indicatedElement.getType().equals((Object)ObjektdateiDOM.EFA_CODES)) {
            IndicatedElement indicatedElement2 = ObjectIndicator.getInstance().getObjectByIdOrSysName("EfaCodes");
            VAUDESObjekt vAUDESObjekt = null;
            try {
                vAUDESObjekt = DatabaseResolver.getInstance().getFromDB("EfaCodes", false);
            }
            catch (NonUniqueResultException nonUniqueResultException) {
                LOGGER.error((Object)"Duplicate Objects with id 'EfaCodes' in database", (Throwable)nonUniqueResultException);
            }
            if (indicatedElement2 != null && vAUDESObjekt == null) {
                arrayList.addAll(TranslatedTextTransformHelper.getTranslatedTextsFromHookOnly(indicatedElement2, locale));
            } else if (indicatedElement2 != null && vAUDESObjekt != null) {
                ArrayList<ITranslatedText> arrayList2 = new ArrayList<ITranslatedText>();
                ArrayList<ITranslatedText> arrayList3 = new ArrayList<ITranslatedText>();
                arrayList2.addAll(TranslatedTextTransformHelper.getTranslatedTextsFromHookOnly(indicatedElement2, locale));
                try {
                    arrayList3.addAll(DatabaseResolver.getInstance().getTranslatedTexts("EfaCodes", locale));
                }
                catch (NonUniqueResultException nonUniqueResultException) {
                    LOGGER.error((Object)"Duplicate Objects with id 'EfaCodes' in database", (Throwable)nonUniqueResultException);
                }
                TranslatedTextTransformHelper.mergeTranslatedTexts(arrayList3, arrayList2);
                arrayList.addAll(arrayList3);
            } else if (indicatedElement2 == null && vAUDESObjekt != null) {
                try {
                    arrayList.addAll(DatabaseResolver.getInstance().getTranslatedTexts("EfaCodes", locale));
                }
                catch (NonUniqueResultException nonUniqueResultException) {
                    LOGGER.error((Object)"Duplicate Objects with id 'EfaCodes' in database", (Throwable)nonUniqueResultException);
                }
            }
        } else {
            arrayList.addAll(TranslatedTextTransformHelper.getTranslatedTextsFromHookOnly(indicatedElement, locale));
        }
        return arrayList;
    }

    private static List<ITranslatedText> getTranslatedTextsFromHookOnly(IndicatedElement indicatedElement, Locale locale) {
        ArrayList<ITranslatedText> arrayList = new ArrayList<ITranslatedText>();
        Object object = DiagnosticDataAccessHelper.parseFile(indicatedElement, VAUDESObjekt.class);
        if (!(object instanceof VAUDESObjekt)) {
            return arrayList;
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        if (null == vAUDESObjekt.getDateien()) {
            return arrayList;
        }
        List<VAUDESObjekt.Dateien.Datei> list = TranslatedTextTransformHelper.getAllTranslatableTextFilesFrom(vAUDESObjekt);
        for (VAUDESObjekt.Dateien.Datei datei : list) {
            Object object2;
            Object object3 = null;
            try {
                if (null != indicatedElement.getInstallationIndexFile()) {
                    object2 = locale;
                    if (ObjectIndicator.getInstance().isTblMode()) {
                        object2 = FALLBACK_LOCALE;
                    }
                    object3 = DiagnosticDataAccessHelper.getLanguageDependentContentFileFromHotfix(indicatedElement.getInstallationIndexFile(), datei, (Locale)object2, VAUDESStringTabelle.class);
                } else {
                    object2 = DiagnosticDataAccessHelper.getContentFileFromObject(indicatedElement, datei.getValue(), VAUDESStringTabelle.class);
                    if (object2 instanceof VAUDESStringTabelle && TranslatedTextTransformHelper.isLocaleEqual(((VAUDESStringTabelle)object2).getSprache(), locale)) {
                        object3 = object2;
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception);
            }
            if (!(object3 instanceof VAUDESStringTabelle) || null == ((VAUDESStringTabelle)(object2 = (VAUDESStringTabelle)object3)).getString()) continue;
            for (String string : ((VAUDESStringTabelle)object2).getString()) {
                HookTranslatedTextWrapper hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
                if (!ObjectIndicator.getInstance().isTblMode()) {
                    hookTranslatedTextWrapper.setLanguage(StringUtils.replaceChars((java.lang.String)((VAUDESStringTabelle)object2).getSprache(), (char)'-', (char)'_'));
                } else {
                    hookTranslatedTextWrapper.setLanguage("od_OD");
                }
                hookTranslatedTextWrapper.setText(TranslatedTextTransformHelper.transformTextContent(string));
                hookTranslatedTextWrapper.setTextId(string.getId());
                hookTranslatedTextWrapper.setTextSource(vAUDESObjekt.getId());
                arrayList.add(hookTranslatedTextWrapper);
                TextCache.getInstance().add(HookTextIdWrapper.create(string.getId(), vAUDESObjekt.getId()), hookTranslatedTextWrapper);
            }
        }
        return arrayList;
    }

    private static List<VAUDESObjekt.Dateien.Datei> getAllTranslatableTextFilesFrom(VAUDESObjekt vAUDESObjekt) {
        ArrayList<VAUDESObjekt.Dateien.Datei> arrayList = new ArrayList<VAUDESObjekt.Dateien.Datei>();
        for (VAUDESObjekt.Dateien.Datei datei : vAUDESObjekt.getDateien().getDatei()) {
            if (!datei.isIstUebersetzbar() || !datei.getType().equals((Object)InhaltdateiDOM.TEXTBESTAND)) continue;
            arrayList.add(datei);
        }
        return arrayList;
    }

    public static List<ITranslatedText> getTranslationsFor(IndicatedElement indicatedElement, java.lang.String string) {
        ArrayList<ITranslatedText> arrayList = new ArrayList<ITranslatedText>();
        if (indicatedElement.getType().equals((Object)ObjektdateiDOM.EFA_CODES)) {
            IndicatedElement indicatedElement2 = ObjectIndicator.getInstance().getObjectByIdOrSysName("EfaCodes");
            VAUDESObjekt vAUDESObjekt = null;
            try {
                vAUDESObjekt = DatabaseResolver.getInstance().getFromDB("EfaCodes", false);
            }
            catch (NonUniqueResultException nonUniqueResultException) {
                LOGGER.error((Object)"Duplicate Objects with id 'EfaCodes' in database", (Throwable)nonUniqueResultException);
            }
            if (indicatedElement2 != null && vAUDESObjekt == null) {
                arrayList.addAll(TranslatedTextTransformHelper.doGetTranslationsFor(indicatedElement, string));
            } else if (indicatedElement2 != null && vAUDESObjekt != null) {
                ArrayList<ITranslatedText> arrayList2 = new ArrayList<ITranslatedText>();
                ArrayList<ITranslatedText> arrayList3 = new ArrayList<ITranslatedText>();
                arrayList2.addAll(TranslatedTextTransformHelper.doGetTranslationsFor(indicatedElement, string));
                try {
                    arrayList3.addAll(DatabaseResolver.getInstance().getTranslations("EfaCodes", string));
                }
                catch (NonUniqueResultException nonUniqueResultException) {
                    LOGGER.error((Object)"Duplicate Objects with id 'EfaCodes' in database", (Throwable)nonUniqueResultException);
                }
                TranslatedTextTransformHelper.mergeTranslatedTexts(arrayList3, arrayList2);
                arrayList.addAll(arrayList3);
            } else if (indicatedElement2 == null && vAUDESObjekt != null) {
                try {
                    arrayList.addAll(DatabaseResolver.getInstance().getTranslations("EfaCodes", string));
                }
                catch (NonUniqueResultException nonUniqueResultException) {
                    LOGGER.error((Object)"Duplicate Objects with id 'EfaCodes' in database", (Throwable)nonUniqueResultException);
                }
            }
        } else {
            arrayList.addAll(TranslatedTextTransformHelper.doGetTranslationsFor(indicatedElement, string));
        }
        return arrayList;
    }

    private static List<ITranslatedText> doGetTranslationsFor(IndicatedElement indicatedElement, java.lang.String string) {
        ArrayList<ITranslatedText> arrayList = new ArrayList<ITranslatedText>();
        Object object = DiagnosticDataAccessHelper.parseFile(indicatedElement, VAUDESObjekt.class);
        if (!(object instanceof VAUDESObjekt)) {
            return arrayList;
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        if (null == vAUDESObjekt.getDateien()) {
            return arrayList;
        }
        if (indicatedElement.getInstallationIndexFile() != null) {
            ArrayList<VAUDESObjekt.Dateien.Datei> arrayList2 = new ArrayList<VAUDESObjekt.Dateien.Datei>();
            for (VAUDESObjekt.Dateien.Datei object22 : vAUDESObjekt.getDateien().getDatei()) {
                if (!object22.isIstUebersetzbar() || !object22.getType().equals((Object)InhaltdateiDOM.TEXTBESTAND)) continue;
                arrayList2.add(object22);
            }
            Object object3 = null;
            try {
                object3 = JaxbUtils.unmarshal(indicatedElement.getInstallationIndexFile(), VAUDESInstallationspaket.class);
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Error parsing installation index file " + indicatedElement.getInstallationIndexFile()), (Throwable)exception);
            }
            if (!(object3 instanceof VAUDESInstallationspaket)) {
                LOGGER.error((Object)("No installation index file found (expected: " + indicatedElement.getInstallationIndexFile().getAbsolutePath() + ")"));
                return arrayList;
            }
            VAUDESInstallationspaket vAUDESInstallationspaket = (VAUDESInstallationspaket)object3;
            for (VAUDESInstallationspaket.Teilpakete.Datei datei : vAUDESInstallationspaket.getTeilpakete().getDatei()) {
                if (!datei.getTpTyp().equals((Object)TeilpaketTYPE.STRUKTUR_TP)) continue;
                try {
                    VAUDESTeilpaket vAUDESTeilpaket;
                    Object object2 = DiagnosticDataAccessHelper.parseFileFromJar(new File(indicatedElement.getInstallationIndexFile().getParentFile(), datei.getValue()), "index.xml", VAUDESTeilpaket.class);
                    if (!(object2 instanceof VAUDESTeilpaket) || null == (vAUDESTeilpaket = (VAUDESTeilpaket)object2).getVerteildateien()) continue;
                    block8: for (VAUDESObjekt.Dateien.Datei datei2 : arrayList2) {
                        for (VAUDESTeilpaket.Verteildateien.Datei datei3 : vAUDESTeilpaket.getVerteildateien().getDatei()) {
                            if (!datei3.getValue().equalsIgnoreCase(datei2.getValue())) continue;
                            ITranslatedText iTranslatedText = TextCache.getInstance().get(HookTextIdWrapper.create(string, vAUDESObjekt.getId()), new Locale(StringUtils.substringBefore((java.lang.String)vAUDESTeilpaket.getSprache(), (java.lang.String)"-"), StringUtils.substringAfter((java.lang.String)vAUDESTeilpaket.getSprache(), (java.lang.String)"-")));
                            if (null != iTranslatedText) {
                                arrayList.add(iTranslatedText);
                                continue;
                            }
                            Object object4 = DiagnosticDataAccessHelper.parseFileFromJar(new File(indicatedElement.getInstallationIndexFile().getParentFile(), datei.getValue()), datei2.getValue(), VAUDESStringTabelle.class);
                            if (!(object4 instanceof VAUDESStringTabelle)) continue;
                            for (String string2 : ((VAUDESStringTabelle)object4).getString()) {
                                if (!string2.getId().equalsIgnoreCase(string)) continue;
                                HookTranslatedTextWrapper hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
                                hookTranslatedTextWrapper.setLanguage(StringUtils.replaceChars((java.lang.String)((VAUDESStringTabelle)object4).getSprache(), (char)'-', (char)'_'));
                                hookTranslatedTextWrapper.setText(TranslatedTextTransformHelper.transformTextContent(string2));
                                hookTranslatedTextWrapper.setTextId(string2.getId());
                                hookTranslatedTextWrapper.setTextSource(vAUDESObjekt.getId());
                                arrayList.add(hookTranslatedTextWrapper);
                                continue block8;
                            }
                            continue block8;
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.error((Object)("Error parsing file from hotfix " + indicatedElement.getInstallationIndexFile()), (Throwable)exception);
                }
            }
        } else {
            List<VAUDESObjekt.Dateien.Datei> list = TranslatedTextTransformHelper.getAllTranslatableTextFilesFrom(vAUDESObjekt);
            for (VAUDESObjekt.Dateien.Datei datei : list) {
                Object object5;
                if (null != datei.getSprache() && null != (object5 = TextCache.getInstance().get(HookTextIdWrapper.create(string, vAUDESObjekt.getId()), new Locale(StringUtils.substringBefore((java.lang.String)datei.getSprache(), (java.lang.String)"-"), StringUtils.substringAfter((java.lang.String)datei.getSprache(), (java.lang.String)"-"))))) {
                    arrayList.add((ITranslatedText)object5);
                    continue;
                }
                try {
                    VAUDESStringTabelle vAUDESStringTabelle;
                    object5 = DiagnosticDataAccessHelper.getContentFileFromObject(indicatedElement, datei.getValue(), VAUDESStringTabelle.class);
                    if (!(object5 instanceof VAUDESStringTabelle) || null == (vAUDESStringTabelle = (VAUDESStringTabelle)object5).getString()) continue;
                    for (String string3 : vAUDESStringTabelle.getString()) {
                        if (!string3.getId().equalsIgnoreCase(string)) continue;
                        HookTranslatedTextWrapper hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
                        hookTranslatedTextWrapper.setLanguage(StringUtils.replaceChars((java.lang.String)vAUDESStringTabelle.getSprache(), (char)'-', (char)'_'));
                        hookTranslatedTextWrapper.setText(TranslatedTextTransformHelper.transformTextContent(string3));
                        hookTranslatedTextWrapper.setTextId(string3.getId());
                        hookTranslatedTextWrapper.setTextSource(vAUDESObjekt.getId());
                        arrayList.add(hookTranslatedTextWrapper);
                    }
                }
                catch (Exception exception) {
                    LOGGER.error((Object)exception);
                }
            }
        }
        return arrayList;
    }

    public static java.lang.String getTextSourceObjectFor(java.lang.String string) {
        java.lang.String string2 = string;
        if (string.equalsIgnoreCase(TextquelleDOM.DOKKATTEXTE.toString())) {
            string2 = TextquelleDOM.DOKKATTEXTE.value();
        } else if (string.equalsIgnoreCase(TextquelleDOM.STANDARDTEXTE.toString())) {
            string2 = TextquelleDOM.STANDARDTEXTE.value();
        } else if (string.equalsIgnoreCase(TextquelleDOM.FAHRZEUGZUSTANDSTEXTE.toString())) {
            string2 = TextquelleDOM.FAHRZEUGZUSTANDSTEXTE.value();
        } else if (string.equalsIgnoreCase(TextquelleDOM.ALLGSYSTEMTEXTE.toString())) {
            string2 = TextquelleDOM.ALLGSYSTEMTEXTE.value();
        } else if (string.equalsIgnoreCase(TextquelleDOM.EFATEXTE.toString())) {
            string2 = "EfaCodes";
        } else if (string.equalsIgnoreCase(TextquelleDOM.TEXTLIB.toString())) {
            string2 = TextquelleDOM.TEXTLIB.value();
        }
        return string2;
    }

    public static void adjustTranslatedTexts(ITranslatedText iTranslatedText, ITranslatedText iTranslatedText2) {
        iTranslatedText.setLanguage(iTranslatedText2.getLanguage());
        iTranslatedText.setText(iTranslatedText2.getText());
        iTranslatedText.setTextId(iTranslatedText2.getTextId());
        iTranslatedText.setTextSource(iTranslatedText2.getTextSource());
    }

    public static ITranslatedText createTranslatedText(String string) {
        HookTranslatedTextWrapper hookTranslatedTextWrapper = new HookTranslatedTextWrapper();
        hookTranslatedTextWrapper.setText(TranslatedTextTransformHelper.transformTextContent(string));
        hookTranslatedTextWrapper.setTextId(string.getId());
        return hookTranslatedTextWrapper;
    }

    public static boolean isLocaleEqual(java.lang.String string, Locale locale) {
        boolean bl = false;
        java.lang.String string2 = "";
        java.lang.String string3 = "";
        java.lang.String string4 = "";
        java.lang.String string5 = "";
        if (null == locale) {
            LOGGER.warn((Object)"received null for locale");
            return bl;
        }
        if (null == string) {
            LOGGER.warn((Object)"received null for language");
            return bl;
        }
        java.lang.String[] stringArray = StringUtils.split((java.lang.String)string, (char)'-');
        if (2 != stringArray.length) {
            stringArray = StringUtils.split((java.lang.String)string, (char)'_');
        }
        if (2 != stringArray.length) {
            LOGGER.error((Object)("Incompatible language in xml found: " + string + " ... aborting transform"));
            return bl;
        }
        string3 = stringArray[0];
        string5 = stringArray[1];
        Pair<java.lang.String, java.lang.String> pair = TranslatedTextTransformHelper.extractOdisServiceLocaleInformation(locale);
        if (null != pair) {
            string2 = pair.getFirst();
            string4 = pair.getSecond();
        }
        bl = TranslatedTextTransformHelper.compareLocaleInformation(string2, string4, string3, string5);
        return bl;
    }

    public static boolean isLocaleEqual(Locale locale, Locale locale2) {
        Pair<java.lang.String, java.lang.String> pair;
        java.lang.String string = "";
        java.lang.String string2 = "";
        java.lang.String string3 = "";
        java.lang.String string4 = "";
        if (null != locale && null != (pair = TranslatedTextTransformHelper.extractOdisServiceLocaleInformation(locale))) {
            string = pair.getFirst();
            string3 = pair.getSecond();
        }
        if (null != locale2.getLanguage()) {
            string2 = locale2.getLanguage();
        }
        if (null != locale2.getCountry()) {
            string4 = locale2.getCountry();
        }
        return TranslatedTextTransformHelper.compareLocaleInformation(string, string3, string2, string4);
    }

    private static Pair<java.lang.String, java.lang.String> extractOdisServiceLocaleInformation(Locale locale) {
        java.lang.String string = "";
        java.lang.String string2 = "";
        Pair<java.lang.String, java.lang.String> pair = null;
        if (StringUtils.isEmpty((java.lang.String)locale.getCountry())) {
            java.lang.String string3 = locale.getLanguage();
            if (null != string3 && string3.length() > 2) {
                java.lang.String[] stringArray = null;
                if (StringUtils.contains((java.lang.String)string3, (char)'_')) {
                    stringArray = StringUtils.split((java.lang.String)string3, (char)'_');
                } else if (StringUtils.contains((java.lang.String)string3, (char)'-')) {
                    stringArray = StringUtils.split((java.lang.String)string3, (char)'-');
                }
                if (null == stringArray || stringArray.length != 2) {
                    LOGGER.error((Object)("Can't handle locale " + locale));
                } else {
                    string = stringArray[0];
                    string2 = stringArray[1];
                }
            } else {
                LOGGER.error((Object)("Can't handle locale " + locale));
            }
        } else {
            if (null != locale.getLanguage()) {
                string = locale.getLanguage();
            }
            if (null != locale.getCountry()) {
                string2 = locale.getCountry();
            }
        }
        if (StringUtils.isNotBlank((java.lang.String)string) && StringUtils.isNotBlank((java.lang.String)string2)) {
            pair = new Pair<java.lang.String, java.lang.String>(string, string2);
        }
        return pair;
    }

    private static boolean compareLocaleInformation(java.lang.String string, java.lang.String string2, java.lang.String string3, java.lang.String string4) {
        boolean bl;
        boolean bl2 = bl = string3.equalsIgnoreCase(string) && string4.equalsIgnoreCase(string2);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(string3 + "_" + string2 + ".equals(" + string + "_" + string4 + ") =" + bl));
        }
        return bl;
    }

    public static java.lang.String createEmptyDto(Locale locale, ITextId iTextId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(iTextId.getSource());
        stringBuilder.append(DiagnosticDataHookConstants.BLANK_STRING);
        stringBuilder.append(locale.getCountry());
        stringBuilder.append(DiagnosticDataHookConstants.BLANK_STRING);
        stringBuilder.append(locale.toString());
        return stringBuilder.toString();
    }

    public static void mergeTranslatedTexts(List<ITranslatedText> list, List<ITranslatedText> list2) {
        if (list.isEmpty()) {
            list.addAll(list2);
            return;
        }
        ArrayList<ITranslatedText> arrayList = new ArrayList<ITranslatedText>();
        block0: for (ITranslatedText iTranslatedText : list) {
            if (null == iTranslatedText.getTextId()) continue;
            for (ITranslatedText iTranslatedText2 : list2) {
                if (null == iTranslatedText2.getTextId() || !iTranslatedText.getTextId().equalsIgnoreCase(iTranslatedText2.getTextId()) || !TranslatedTextTransformHelper.isLocaleEqual(iTranslatedText.getLanguage(), iTranslatedText2.getLanguage())) continue;
                TranslatedTextTransformHelper.adjustTranslatedTexts(iTranslatedText, iTranslatedText2);
                arrayList.add(iTranslatedText2);
                continue block0;
            }
        }
        list2.removeAll(arrayList);
        list.addAll(list2);
    }

    public static boolean isLocaleEqual(java.lang.String string, java.lang.String string2) {
        boolean bl = false;
        if (null != string && null != string2) {
            bl = string.equalsIgnoreCase(string2);
        }
        return bl;
    }

    static {
        FALLBACK_LOCALE = new Locale("od", "OD");
    }
}

