<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- *************************************************** Stylesheet-Importe *************** -->
	<xsl:import href="function_templates.xsl"/>
	<xsl:import href="head_information.xsl"/>
	<xsl:import href="diagnosis.xsl"/>
	<xsl:import href="eventmemory.xsl"/>
	<xsl:import href="testplans.xsl"/>
	<xsl:import href="worksteps.xsl"/>
	<xsl:import href="functiontests.xsl"/>
	<xsl:import href="css.xsl" />
	<!-- ********************************* Output-Definition: HTML 5 kompatibel *************** -->
	<xsl:output method="html" indent="no" encoding="UTF-8" doctype-system="about:legacy-compat" omit-xml-declaration="yes" />

	<!-- *************************************************** Versionsvariablen *************** -->
	<xsl:variable name="V_Stylesheet_Version_XML_to_HTML_Main" select="'5.94.0'"/>
	<xsl:variable name="V_Stylesheet_Datum_XML_to_HTML_Main" select="'13.05.2022'"/>
 
 <!-- %version: 63 %
    Versionsinformationen zum Gesamt-Stylesheet und zum verwendetem Schema.
    Hinweis: bei jeder Anpassung eines untergeordneten Stylesheets muss auch hier 
    die Versionsnummer hochgezählt werden.
  -->
	<xsl:variable name="V_Stylesheet_Version" select="2.6"/>
	<xsl:variable name="V_Schema_Version" select="2.60"/>
	<xsl:param name="V_expand_tree_views">false</xsl:param>

	<!-- *********** Fallback für Übersetzung der statischen Texte ************************* -->	
	<xsl:param name="Text_diagnosis_protocol_title" >Diagnoseprotokoll</xsl:param>
	<xsl:param name="Text_Odis_Vaudas" >Offboard Diagnostic Information System-Diagnoseprotokoll</xsl:param>
	<xsl:param name="Text_diagnosis" >Diagnosesitzung</xsl:param>
	<xsl:param name="Text_installed_gfs" >-Installierte Diagnosedaten-</xsl:param>
	<xsl:param name="Text_used_gfs" >-Verwendete Diagnosedaten-</xsl:param>
	<xsl:param name="Text_GFS_version" >-GFS DIDB Version-</xsl:param>
	<xsl:param name="Text_GFS_technicalVersion" >-GFS technische Version-</xsl:param>
	<xsl:param name="Text_GFS_language" >-GFS DIDB Sprache-</xsl:param>
	<xsl:param name="Text_GFS_marque" >-GFS DIDB Marke-</xsl:param>
	<xsl:param name="Text_base_version" >-Basis DIDB Version-</xsl:param>
	<xsl:param name="Text_base_language" >-Basis DIDB Sprache-</xsl:param>
	<xsl:param name="Text_dtc_excl_version">-DTC_Exclusion Version-</xsl:param>
	<xsl:param name="Text_dtc_factors_version">-DTC_Factors Version-</xsl:param>
	<xsl:param name="Text_diagnosis_protocol_long_title" >Diagnoseprotokoll (lang)</xsl:param>
	<xsl:param name="Text_diagnosis_protocol_short_title" >Diagnoseprotokoll (kurz)</xsl:param>
	<xsl:param name="Text_diagnosis_protocol_functiontest_title" >Diagnoseprotokoll (Funktionsprüfung)</xsl:param>
	<xsl:param name="Text_diagnosis_protocol_autosave" > - autosave</xsl:param>
	<xsl:param name="Text_eventmemory_long" >Erster Systemtest mit Ereignisspeicher-Einträgen</xsl:param>
	<xsl:param name="Text_no_more_ecu_traces" >Keine Systemtests vorhanden!</xsl:param>
	<xsl:param name="Text_eventmemory_short" >Weitere Systemtests mit Ereignisspeicher-Einträgen</xsl:param>
	<xsl:param name="Text_eventmemory_number" >Systemtests Nr.</xsl:param>
	<xsl:param name="Text_ecu_adress" >Adresse</xsl:param>
	<xsl:param name="Text_ecu_systemname" >Systemname</xsl:param>
	<xsl:param name="Text_ecu_variant" >Protokollvariante</xsl:param>
	<xsl:param name="Text_ecu_base_variant_asam" >ASAM-Basis-Variante</xsl:param>
	<xsl:param name="Text_ecu_ecu_variant_asam" >ASAM-Steuergerät-Variante</xsl:param>
	<xsl:param name="Text_ecu_subbussystem" >Subbussystem</xsl:param>
	<xsl:param name="Text_ecu_subbussystem_no_data" >Klasse 0 Teilnehmer - keine Identifikationsdaten</xsl:param>
	<xsl:param name="Text_ecu_subbussystem_programming_hash" >ProgrammingHash</xsl:param>
	<xsl:param name="Text_ecu_subbussystem_configuration_hash" >ConfigurationHash</xsl:param>
	<xsl:param name="Text_ecu_no_data" >Keine Daten zu der Reizadresse vorhanden!</xsl:param>
	<xsl:param name="Text_ecu_hw_partnumber" >Hardware Teilenummer</xsl:param>
	<xsl:param name="Text_ecu_sw_partnumber" >Teilenummer</xsl:param>
	<xsl:param name="Text_ecu_hw_versionnumber" >Hardware Versionsnummer</xsl:param>
	<xsl:param name="Text_ecu_sw_versionnumber" >Software Versionsnummer</xsl:param>
	<xsl:param name="Text_ecu_manufacturing_date" >Fertigungsdatum</xsl:param>
	<xsl:param name="Text_ecu_coding" >Codierung</xsl:param>
	<xsl:param name="Text_ecu_coding_index" >Index</xsl:param>
	<xsl:param name="Text_ecu_coding_byte" >Byte</xsl:param>
	<xsl:param name="Text_ecu_coding_hex_value" >Wert (hex)</xsl:param>
	<xsl:param name="Text_ecu_coding_bin_value" >Wert (bin)</xsl:param>
	<xsl:param name="Text_ecu_flashable" >Flashbarkeit</xsl:param>
	<xsl:param name="Text_unknown" >unbekannt</xsl:param>
	<xsl:param name="Text_flashable" >flashbar</xsl:param>
	<xsl:param name="Text_not_flashable" >nicht flashbar</xsl:param>
	<xsl:param name="Text_ecu_asam_odx_file_identifier" >ASAM 2D/ODX-Datensatz</xsl:param>
	<xsl:param name="Text_ecu_asam_odx_file_version" >ASAM 2D/ODX-Datensatz-Version</xsl:param>
	<xsl:param name="Text_ecu_used_asam_odx_file" >verw. ASAM/ODX SG-Variante</xsl:param>
	<xsl:param name="Text_ecu_VWDataSetNumberOrECUDataContainerNumber" >Ziel-Datencontainer</xsl:param>
	<xsl:param name="Text_ecu_VWDataSetVersionNumber" >Version des Ziel-Datencontainers</xsl:param>
	<xsl:param name="Text_ecu_VehicleEquipmentCodeAndPRNumberCombination" >Ausstattungscode</xsl:param>
	<xsl:param name="Text_ecu_VWWorkshopSystemName" >Ausstattungscode</xsl:param>
	<xsl:param name="Text_ecu_eventmemory_data" >Ereignisspeichereintrag</xsl:param>
	<xsl:param name="Text_eventmemory_no" >Nummer</xsl:param>
	<xsl:param name="Text_eventmemory_fault_type_number_1" >Fehlerart 1</xsl:param>
	<xsl:param name="Text_eventmemory_fault_type_number_2" >Fehlerart 2</xsl:param>
	<xsl:param name="Text_eventmemory_symptom" >Symptom</xsl:param>
	<xsl:param name="Text_eventmemory_dtctext" >Text</xsl:param>
	<xsl:param name="Text_eventmemory_status" >Status</xsl:param>
	<xsl:param name="Text_eventmemory_fault_unjustified" >unberechtigt</xsl:param>
	<xsl:param name="Text_eventmemory_default_values" >Standard Umgebungsbedingungen</xsl:param>
	<xsl:param name="Text_eventmemory_default_values_date" >Datum</xsl:param>
	<xsl:param name="Text_eventmemory_default_values_time" >Zeit</xsl:param>
	<xsl:param name="Text_eventmemory_default_values_priority" >Priorität</xsl:param>
	<xsl:param name="Text_eventmemory_default_values_error_frequency" >vom</xsl:param>
	<xsl:param name="Text_eventmemory_default_values_unlearn_counter" >vom</xsl:param>
	<xsl:param name="Text_eventmemory_environment" >Erweiterte Umgebungsbedingungen</xsl:param>
	<xsl:param name="Text_eventmemory_environment_type" >Häufigkeitszähler</xsl:param>
	<xsl:param name="Text_eventmemory_environment_value" >Wert</xsl:param>
	<xsl:param name="Text_eventmemory_environment_scale" >Einheit</xsl:param>
	<xsl:param name="Text_from" >vom</xsl:param>
	<xsl:param name="Text_headline_head_information" >Allgemeine Informationen</xsl:param>
	<xsl:param name="Text_session_id" >Session-ID</xsl:param>
	<xsl:param name="Text_protocol_type" >Protokolltyp</xsl:param>
	<xsl:param name="Text_protocol_type_1" >Flashprotokoll</xsl:param>
	<xsl:param name="Text_protocol_type_2" >Geführte Fehlersuche</xsl:param>
	<xsl:param name="Text_protocol_type_3" >Geführte Funktionen</xsl:param>
	<xsl:param name="Text_protocol_type_4" >Basisprotokoll</xsl:param>
	<xsl:param name="Text_protocol_type_5" >Simulationsprotokoll</xsl:param>
	<xsl:param name="Text_protocol_type_6" >Supportprotokoll</xsl:param>
	<xsl:param name="Text_protocol_type_7" >Bauzustandsdokumentation nicht diagnosefähiger Bauteile</xsl:param>
	<xsl:param name="Text_order_no" >Auftragsnummer</xsl:param>
	<xsl:param name="Text_protocol_status" >Protokollstatus</xsl:param>
	<xsl:param name="Text_protocol_status_final" >Abschlussprotokoll</xsl:param>
	<xsl:param name="Text_protocol_status_intermediate" >Zwischenprotokoll</xsl:param>
	<xsl:param name="Text_document_name" >Protokollart</xsl:param>
	<xsl:param name="Text_document_name_diagnosis" >Diagnoseprotokoll</xsl:param>
	<xsl:param name="Text_document_name_simulation" >Simulationsprotokoll</xsl:param>
	<xsl:param name="Text_dtc_factor">Bewertungsfaktor</xsl:param>
	<xsl:param name="Text_workshop_information" >Werkstatt-Informationen</xsl:param>
	<xsl:param name="Text_workshop_serial_no" >Seriennummer Diagnosetester</xsl:param>
	<xsl:param name="Text_workshop_software_name" >Hardwareplattform</xsl:param>
	<xsl:param name="Text_workshop_operatingsystem" >Betriebssystem</xsl:param>
	<xsl:param name="Text_workshop_vci_type" >VCI-Typ</xsl:param>
	<xsl:param name="Text_workshop_vci_connection_type" >VCI-Verbindungstyp</xsl:param>
	<xsl:param name="Text_workshop_communication_type" >Kommunikationsweg</xsl:param>
	<xsl:param name="Text_workshop_importer_no" >Importeursnummer</xsl:param>
	<xsl:param name="Text_workshop_garage_no" >Händler-/Betriebsnummer</xsl:param>
	<xsl:param name="Text_workshop_dealership_identifier" >Betriebskennzeichnung</xsl:param>
	<xsl:param name="Text_workshop_dealerstatusgvo" >Vertragsstatus</xsl:param>
	<xsl:param name="Text_workshop_dealerstatusgvo_contractDealer" >Vertragshändler</xsl:param>
	<xsl:param name="Text_workshop_dealerstatusgvo_freeDealer" >freier Händler</xsl:param>
	<xsl:param name="Text_license_type">Lizenz-Typ</xsl:param>
	<xsl:param name="Text_session_start" >Start der Diagnose</xsl:param>
	<xsl:param name="Text_session_utc" >Start der Diagnose UTC</xsl:param>
	<xsl:param name="Text_session_time_spent" >Zeitaufwand (ZE)</xsl:param>
	<xsl:param name="Text_session_time_warranty_net">Zeitaufwand (Netto ZE)</xsl:param>
	<xsl:param name="Text_global_variables" >Globale Variablen</xsl:param>
	<xsl:param name="Text_global_variables_name" >Name</xsl:param>
	<xsl:param name="Text_global_variables_type" >Typ</xsl:param>
	<xsl:param name="Text_global_variables_content" >Inhalt</xsl:param>
	<xsl:param name="Text_sw_versions" >Software-Versionen</xsl:param>
	<xsl:param name="Text_sw_version_vaudas" >Offboard Diagnostic Information System Service</xsl:param>
    <xsl:param name="Text_sw_version_vaudas_main_feature" >Haupt-Feature</xsl:param>
	<xsl:param name="Text_sw_version_mcd_server_vendor_name" >MCD-Server Hersteller</xsl:param>
	<xsl:param name="Text_sw_version_mcd_server_vendor_product_name" >MCD-Server Name</xsl:param>
	<xsl:param name="Text_sw_version_mcd_server_vendor_version" >MCD-Server Version</xsl:param>
	<xsl:param name="Text_sw_version_mcd_server_api_version" >MCD-Server API-Version</xsl:param>
	<xsl:param name="Text_sw_version_pdu_api_software_name" >PDU-API Hersteller</xsl:param>
	<xsl:param name="Text_sw_version_pdu_api_software_version" >PDU-API Version</xsl:param>
	<xsl:param name="Text_sw_version_pdu_api_api_version" >PDU-API API-Version</xsl:param>
	<xsl:param name="Text_sw_version_ecu_framework" >ECF Version</xsl:param>
	<xsl:param name="Text_sw_version_smard_lang" >General Testscript API Version</xsl:param>
	<xsl:param name="Text_sw_version_vaudas_smard_lang" >Testscript API Version</xsl:param>
	<xsl:param name="Text_sw_version_vaudas_measurement_types" >Measurement Types</xsl:param>
	<xsl:param name="Text_sw_version_baseline" >Baseline Version</xsl:param>
	<xsl:param name="Text_hotfix" >Hotfix</xsl:param>
	<xsl:param name="Text_hotfix_loaded" >Geladen</xsl:param>
	<xsl:param name="Text_hotfix_unloaded" >Entladen</xsl:param>
	<xsl:param name="Text_vehicle" >Fahrzeug</xsl:param>
	<xsl:param name="Text_vehicle_marque" >Marke</xsl:param>
	<xsl:param name="Text_vehicle_type" >Typ</xsl:param>
	<xsl:param name="Text_vehicle_model_year" >Modelljahr</xsl:param>
	<xsl:param name="Text_vehicle_body_version" >Variante</xsl:param>
	<xsl:param name="Text_vehicle_engine_code" >Motorkennbuchstabe</xsl:param>
	<xsl:param name="Text_vehicle_chassis_number_automatic" >Fahrgestellnummer (automatisch)</xsl:param>
	<xsl:param name="Text_vehicle_chassis_number_user" >Fahrgestellnummer (manuell)</xsl:param>
	<xsl:param name="Text_vehicle_asam_name" >ASAM-Projekt-Name</xsl:param>
	<xsl:param name="Text_vehicle_asam_version" >ASAM-Projekt-Version</xsl:param>
	<xsl:param name="Text_vin_changes" >Fahrzeugwechsel</xsl:param>
	<xsl:param name="Text_vin_changes_timestamp" >Zeitpunkt</xsl:param>
	<xsl:param name="Text_vin_changes_number" >Fahrgestellnummer</xsl:param>
	<xsl:param name="Text_error_messages" >Fehlermeldungen außerhalb der Geführten Fehlersuche</xsl:param>
	<xsl:param name="Text_error" >Fehler</xsl:param>
	<xsl:param name="Text_error_text" >Text</xsl:param>
	<xsl:param name="Text_dec_content" >Quellenangaben der Diagnoseeinstiegsdaten</xsl:param>
	<xsl:param name="Text_dec_time_ident" >Zeitstempel Identifikationsdaten aus Konzernsystem:</xsl:param>
	<xsl:param name="Text_dec_time_dtc" >Zeitstempel Ereignisspeichereinträge aus Konzernsystem:</xsl:param>
	<xsl:param name="Text_dec_none" >Es wurden keine Daten aus dem Konzernsystem verwendet.</xsl:param>
	<xsl:param name="Text_source" >Datenquelle</xsl:param>
	<xsl:param name="Text_source_backend" >Konzernsystem</xsl:param>
	<xsl:param name="Text_source_vehicle" >Fahrzeug</xsl:param>
	<xsl:param name="Text_functiontests" >Funktionsprüfungen</xsl:param>
	<xsl:param name="Text_no_functiontests" >Keine Funktionsprüfungen vorhanden!</xsl:param>
	<xsl:param name="Text_last_functiontest" >Aktuelle Funktionsprüfung</xsl:param>
	<xsl:param name="Text_functiontest" >Funktionsprüfung</xsl:param>
	<xsl:param name="Text_functiontest_result" >Ergebnis</xsl:param>
	<xsl:param name="Text_functiontest_warranty_net_void">Von Netto ZE ausgeschlossen</xsl:param>
	<xsl:param name="Text_backgroundtests">Hintergrundprüfungen</xsl:param>
	<xsl:param name="Text_no_backgroundtests">Keine Hintergrundprüfungen vorhanden!</xsl:param>
	<xsl:param name="Text_backgroundtest">Hintergrundprüfung</xsl:param>
	<xsl:param name="Text_teststep" >Prüfschritt</xsl:param>
	<xsl:param name="Text_teststep_content_action" >Aktion</xsl:param>
	<xsl:param name="Text_teststep_content_action_output" >Ausgabe</xsl:param>
	<xsl:param name="Text_teststep_content_action_input" >Eingabe</xsl:param>
	<xsl:param name="Text_teststep_content_action_jump" >Sprung</xsl:param>
	<xsl:param name="Text_teststep_content_cancel_reason">Abbruchgrund</xsl:param>
	<xsl:param name="Text_teststep_content_cancel_hint">Beschreibung / Hinweis</xsl:param>
	<xsl:param name="Text_teststep_content_cancel_desc_a1">A1 (Prüfprogrammabbruch aufgrund Falscheingabe oder falsche Programmwahl)</xsl:param>
	<xsl:param name="Text_teststep_content_cancel_desc_a2">A2 (Prüfplan nicht zielführend/fehlerhaft)</xsl:param>
	<xsl:param name="Text_teststep_content_cancel_desc_a3">A3 (Bauteildefekt durch Sichtprüfung/Zustandsprüfung erkannt)</xsl:param>
	<xsl:param name="Text_teststep_content_cancel_desc_a4">A4 (Prüfvoraussetzungen nicht erreicht)</xsl:param>
	<xsl:param name="Text_teststep_content_cancel_desc_a5">A5 (Prüfprogrammabbruch aufgrund…)</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom" >Steuergeräte-Kommunikation</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_type_KWP" >KWP</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_type_UDS" >UDS</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_type_KWP_functional" >KWP funktional</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_type_UDS_functional" >UDS funktional</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_type_unknown" >Protokoll unbekannt</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_link" >Steuergerät</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_jobstatus" >Jobstatus</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_request" >Request</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_service" >Dienst</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_request_parameter" >Request-Parameter</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_request_no_param" >Keine Parameter</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_request_parameter_name" >Name</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_request_parameter_index" >Nummer</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_request_parameter_value" >Wert</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_no_response" >Keine Antwort vom Steuergerät</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_response" >Antwort vom Steuergerät</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_response_parameter" >Response-Parameter</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_response_parameter_name" >Name</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_response_parameter_value" >Wert</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_response_no_param" >Keine Response-Parameter</xsl:param>
	<xsl:param name="Text_teststep_content_ecukom_response_nrc" >NRC</xsl:param>
	<xsl:param name="Text_teststep_content_error_id" >Fehler-Id</xsl:param>
	<xsl:param name="Text_teststep_content_error_message" >Fehlermeldung</xsl:param>
    <xsl:param name="Text_teststep_content_standard_measurement" >Messtechnik</xsl:param>
    <xsl:param name="Text_teststep_content_measurement_value" >Messwerte</xsl:param>
    <xsl:param name="Text_standard_measurement_error" >Messtechnik-Fehlermeldung</xsl:param>
    <xsl:param name="Text_standard_measurement_used_hardware" >Eingesetzte Messtechnik</xsl:param>
    <xsl:param name="Text_standard_measurement_type" >Messart</xsl:param>
    <xsl:param name="Text_standard_measurement_tolerance_io" >Sollwert i.O.</xsl:param>
    <xsl:param name="Text_standard_measurement_tolerance_nio" >Sollwert n.i.O.</xsl:param>
    <xsl:param name="Text_standard_measurement_value" >Messwert</xsl:param>
    <xsl:param name="Text_standard_measurement_state" >Messstatus</xsl:param>
    <xsl:param name="Text_standard_measurement_errorcode" >Fehlercode</xsl:param>
    <xsl:param name="Text_standard_measurement_device_identification" >Angeschlossene Komponenten</xsl:param>
    <xsl:param name="Text_standard_measurement_firmware" >Firmware-Version</xsl:param>
    <xsl:param name="Text_standard_measurement_check_sensor" >Prüfung, ob Messsensor vorhanden ist</xsl:param>
    <xsl:param name="Text_standard_measurement_check_sensor_connector" >Anschluss</xsl:param>
    <xsl:param name="Text_standard_measurement_check_sensor_sensor" >Sensor</xsl:param>
    <xsl:param name="Text_standard_measurement_check_sensor_result" >Ergebnis</xsl:param>
    <xsl:param name="Text_standard_measurement_replacement_value" >Ersatzwert</xsl:param>
	<xsl:param name="Text_measurement_value_name" >Name</xsl:param>
	<xsl:param name="Text_measurement_value_value" >Wert</xsl:param>
	<xsl:param name="Text_measurement_value_target_value" >Sollwert</xsl:param>
	<xsl:param name="Text_measurement_value_identification" >Identifikation</xsl:param>
	<xsl:param name="Text_teststep_content_function_call" >Funktionsaufruf</xsl:param>
	<xsl:param name="Text_teststep_content_function_call_parameter" >Parameter</xsl:param>
	<xsl:param name="Text_teststep_content_function_return" >Funktionsrückkehr</xsl:param>
	<xsl:param name="Text_teststep_content_function_return_result" >Ergebnis</xsl:param>
    <xsl:param name="Text_teststep_content_identifikation_auslesen" >Aktion: Identifikationsdaten auslesen</xsl:param>
    <xsl:param name="Text_teststep_content_identifikation_auslesen_read_subsystems" >mit Subsystemen</xsl:param>
    <xsl:param name="Text_teststep_content_identifikation_auslesen_read_subsystems_true" >ja</xsl:param>
    <xsl:param name="Text_teststep_content_identifikation_auslesen_read_subsystems_false" >nein</xsl:param>
    <xsl:param name="Text_teststep_content_identifikation_auslesen_status" >Status</xsl:param>
    <xsl:param name="Text_teststep_content_identifikation_auslesen_status_0" >kein Steuergerät erkannt</xsl:param>
    <xsl:param name="Text_teststep_content_identifikation_auslesen_status_1" >Steuergeräte erkannt</xsl:param>
    <xsl:param name="Text_teststep_content_identifikation_auslesen_ecus" >Identifizierte Steuergeräte</xsl:param>
	<xsl:param name="Text_functiontest_local_variables" >Lokale Variablen</xsl:param>
	<xsl:param name="Text_functiontest_local_variables_name" >Name</xsl:param>
	<xsl:param name="Text_functiontest_local_variables_type" >Typ</xsl:param>
	<xsl:param name="Text_functiontest_local_variables_content" >Inhalt</xsl:param>
	<xsl:param name="Text_worksteps" >Durchgeführte Arbeitsschritte</xsl:param>
	<xsl:param name="Text_workstep_number" >Nr.</xsl:param>
	<xsl:param name="Text_workstep_mask" >Maske</xsl:param>
	<xsl:param name="Text_workstep_result" >Ergebnis</xsl:param>
	<xsl:param name="Text_workstep_function_test_id" >Test-Id</xsl:param>
	<xsl:param name="Text_workstep_function_test_runtime_id" >Laufzeit-Id</xsl:param>
	<xsl:param name="Text_workstep_origin" >Herkunft</xsl:param>
	<xsl:param name="Text_workstep_origin_efa_origin_status" >EFA-Statu</xsl:param>
	<xsl:param name="Text_workstep_origin_efa_efa_objectID" >EFA-Bauteil/Funktion</xsl:param>
	<xsl:param name="Text_workstep_origin_efa_efa_errorTypeID" >EFA-Fehlerart</xsl:param>
	<xsl:param name="Text_workstep_origin_efa_efa_errorLocationID" >EFA-Lage</xsl:param>
	<xsl:param name="Text_workstep_origin_efa_efa_errorConditionID" >EFA-Randbedingung</xsl:param>
	<xsl:param name="Text_workstep_origin_tpi" >TPI</xsl:param>
	<xsl:param name="Text_workstep_origin_efa" >EFA</xsl:param>
	<xsl:param name="Text_workstep_origin_Verdacht" >Verdacht</xsl:param>
	<xsl:param name="Text_workstep_origin_systemplan" >Systemplan</xsl:param>
	<xsl:param name="Text_workstep_origin_system" >System</xsl:param>
	<xsl:param name="Text_workstep_origin_gff" >Geführte Funktionen</xsl:param>
	<xsl:param name="Text_workstep_origin_moduleselect" >Bauteilauswahl</xsl:param>
	<xsl:param name="Text_testplans" >Prüfpläne</xsl:param>
	<xsl:param name="Text_no_testplans" >Keine Prüfpläne vorhanden!</xsl:param>
	<xsl:param name="Text_testplan" >Prüfplan</xsl:param>
	<xsl:param name="Text_testplan_unjustified">Unberechtigt</xsl:param>
	<xsl:param name="Text_testplan_inherited_fault">Folgefehler</xsl:param>
	<xsl:param name="Text_testplan_implicit_IO">Prüfung nicht mehr erforderlich</xsl:param>
	<xsl:param name="Text_testplan_fault" >Fehlerliste</xsl:param>
	<xsl:param name="Text_testplan_fault_ecu_variant" >Steuergerätadresse</xsl:param>
	<xsl:param name="Text_testplan_fault_fault_number" >Fehler</xsl:param>
	<xsl:param name="Text_ecu_name" >Systembezeichnung</xsl:param>
	<xsl:param name="Text_testplan_repair_probability" >Wahrscheinlichkeit</xsl:param>
	<xsl:param name="Text_testplan_probability_factor" >Bewertungsfaktor</xsl:param>
	<xsl:param name="Text_testplan_repair_location" >Reparaturort</xsl:param>
	<xsl:param name="Text_testplan_repair_location_mobile" >Mobil</xsl:param>
	<xsl:param name="Text_testplan_repair_location_remote" >Remote</xsl:param>
	<xsl:param name="Text_testplan_repair_location_garage" >Werkstatt</xsl:param>
	
	<!-- Eingefuegte bzw. geaenderte Texte ab Version 1.4 -->
	<xsl:param name="Text_vehicle_lifetime_mileage_in_km" >Laufleistung (km)</xsl:param>
	<xsl:param name="Text_sw_version_group_point_weitere" >Weitere</xsl:param>
	<xsl:param name="Text_ecu_eventmemory_summary" >Ereignisse</xsl:param>
	<xsl:param name="Text_ecu_identification_group" >Identifikation</xsl:param>
	<xsl:param name="Text_ecu_eventmemory_group" >Ereignisspeichereinträge</xsl:param>
	<xsl:param name="Text_ecu_subsystems_group" >Subsysteme</xsl:param>
	<xsl:param name="Text_session_stop" >Ende der Diagnose</xsl:param>
	<xsl:param name="Text_session_stop_utc" >Ende der Diagnose UTC</xsl:param>
	<xsl:param name="Text_call_parameter_group" >Parameter</xsl:param>
	<xsl:param name="Text_eventmemory_default_values_mileage" >km-Stand (DTC)</xsl:param>
	<xsl:param name="Text_expand_all">Alle expandieren</xsl:param>
	<xsl:param name="Text_collapse_all">Alle zuklappen</xsl:param>
	<xsl:param name="Text_href_functiontest_top">Nach oben</xsl:param>
	<xsl:param name="Text_workstep_action_type_MESSAGE">Meldung</xsl:param>
	<xsl:param name="Text_workstep_action_type_SELECTION">Auswahl</xsl:param>
	<xsl:param name="Text_workstep_action_type_INPUT">Eingabe</xsl:param>
	<xsl:param name="Text_workstep_action_type_JUMP">Prüfschrittsprung</xsl:param>
	<xsl:param name="Text_workstep_action_type_ERROR">Fehler</xsl:param>
	<xsl:param name="Text_workstep_action_type_SUBTESTSTEP_START">Start Testprozedur</xsl:param>
	<xsl:param name="Text_workstep_action_type_SUBTESTSTEP_FINISHED">Ende Testprozedur</xsl:param>
	<xsl:param name="Text_session_statistic" >Statistic</xsl:param>
    <xsl:param name="Text_session_global_interaction" >Diagnosesitzung</xsl:param>
    <xsl:param name="Text_session_start_interaction" >Diagnoseeinstieg</xsl:param>
    <xsl:param name="Text_session_end_interaction" >Diagnoseausstieg</xsl:param>
    <xsl:param name="Text_session_programs_interaction" >Funktionsprüfungen</xsl:param>
    <xsl:param name="Text_session_program_mouse_click_count" >Mausklicks</xsl:param>
    <xsl:param name="Text_session_program_key_pressed_count" >Tastatureingaben</xsl:param>
    <xsl:param name="Text_session_program_exclude_test_time" >Von der Gesamtdiagnosezeit ausgeschlossen</xsl:param>
    <xsl:param name="Text_dialog_message" >Meldung</xsl:param>

	<xsl:param name="Text_dtc_read_failed_hint" >Fehler beim Lesen der Ereignisspeicher</xsl:param>
	<xsl:param name="Text_dtc_read_not_responding_hint" >Das Steuergerät antwortet auf die Ereignisspeicheranfrage nicht</xsl:param>
	<xsl:param name="Text_regulation_based_sw_ident" >Regulierungsbezogene Software-Identifikationsnummern</xsl:param>
	<xsl:param name="Text_regulation_ident" >Regulation_Identification</xsl:param>
	<xsl:param name="Text_sw_ident" >Software_identification</xsl:param>

	<xsl:param name="Text_cyc_diagnosis_protocol_title" >Diagnoseprotokoll FVA</xsl:param>
	<xsl:param name="Text_cyc_ecu_sw_number" >ECU Software Nummer</xsl:param>
	<xsl:param name="Text_cyc_ecu_core_assembly_number" >Kernbaugruppen Nummer</xsl:param>
	<xsl:param name="Text_cyc_ecu_delivery_assembly_number" >Liefer-/Montagenummer</xsl:param>
	<xsl:param name="Text_cyc_sub_diag_spec_number" >Subsystem Diagnoseteilenummer</xsl:param>
	<xsl:param name="Text_cyc_diag_spec_version" >Diagnose Spezifikationsversion</xsl:param>
	<xsl:param name="Text_cyc_nos_msg_version_number" >NOS Nachrichtendatenbank Version</xsl:param>
	<xsl:param name="Text_cyc_vehicle_ident_number" >Fahrzeug Identifikationsnummer</xsl:param>
	<xsl:param name="Text_cyc_serial_number" >Seriennummer</xsl:param>
	<xsl:param name="Text_cyc_calibration_number" >kalibrierungsnummer</xsl:param>
	<xsl:param name="Text_cyc_ext_hardware_number" >Externe Hardwarenummer</xsl:param>
	<xsl:param name="Text_cyc_hardware_number" >Hardwarenummer</xsl:param>
	<xsl:param name="Text_eventmemory_snapshot" >Snapshot</xsl:param>
    <xsl:param name="Text_cyc_dtc">Diagnostic Trouble Code</xsl:param>
    <xsl:param name="Text_cyc_dtc_text">Diagnostic Trouble Code Text</xsl:param>
    <xsl:param name="Text_cyc_dtc_value">Trouble Code Value</xsl:param>
    <xsl:param name="Text_cyc_dtc_state">Status DTC</xsl:param>
    <xsl:param name="Text_cyc_cycle_counter">Verlernzähler</xsl:param>
    <xsl:param name="Text_cyc_snapshot_number">Snapshot Nummer</xsl:param>
    <xsl:param name="Text_cyc_freezedata_field">FreezeData Bytefield</xsl:param>
    <xsl:param name="Text_cyc_freezedata_value">FreezeData String</xsl:param>

    <xsl:param name="Text_cooperation">Kooperation</xsl:param>
	
	<!-- Diss related:  enable replacement of translation placeholders with template, 1 = switched on -->
	<xsl:param name="ReplaceI18nPlaceholder">1</xsl:param>
	<xsl:param name="isJavascriptEnabled">true</xsl:param>
	<xsl:param name="MirrorServerUrl">1</xsl:param>
	
	
	<!-- **************************************************************************************************************************** -->
	<!-- template T_Vaudas_diag_prot_main -->
	<!-- Main - Template -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_Vaudas_diag_prot_main">

    <!-- select correct title-->
    <xsl:variable name="V_Title">
      <xsl:choose>
        <xsl:when test="vehicle_data/cooperation">
          <xsl:value-of select="$Text_cyc_diagnosis_protocol_title" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$Text_diagnosis_protocol_title" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <html>
			<head>
			    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
				<xsl:call-template name="T_Vaudas_diag_prot_css" />
		<xsl:choose>
	  	<xsl:when test="$isJavascriptEnabled = 'true'">
				<script type="text/javascript">
					<!--function Change_table_content()
       {
         return '\x3ctr\x3e\x3ctd\x3e\x3cbr\x3e\x3c/td\x3e\x3c/tr\x3e';
       }

       function NewLine(newline)
       {
          if (newline != '')
          {
            newline2=(newline-1)*10;
             string='\x3c/p\x3e\x3cp class=\"default_style\" style=\"margin-top:'+newline2+'pt;margin-bottom:0;\"\x3e';
            return string;
          }
       }

       function WriteImageTag(path)
       {
         return '\x3cimg src=\"' + path + '\"\x3e\x3c/img\x3e\n';
       }--><![CDATA[
       function write_date()
       {
         var d = new Date();
         var da = ("0" + d.getDate()).slice(-2) + "-" +
                  ("0"+(d.getMonth()+1)).slice(-2) + "-" + 
                  d.getFullYear() + " " + 
                  ("0" + d.getHours()).slice(-2) + ":" +
                  ("0" + d.getMinutes()).slice(-2);
         document.write(da);
       }
      
		function showHideSectionsAfterCheckbox(checkbox) {
			//TODO Intercept double triggers because of bad IE8 understanding of "onChange"
			var startMarker = document.getElementById("start_marker_"+checkbox.id);
			showHideSectionByNode(startMarker.nextSibling, !(checkbox.checked));
		}
		
		function showSectionsByID(id) {
			var checkbox = document.getElementById("treeView_"+id);
			checkbox.checked=true;
			showHideSectionsAfterCheckbox(checkbox);
		}
		
		function init_treeViews() {
			var input_elements = document.getElementsByName("treeView_checkbox");
			for (var i=0; i<input_elements.length; i++) {
				showHideSectionsAfterCheckbox(input_elements[i]);
			}
		}
		
		function set_all_treeViews(expand) {
			var input_elements = document.getElementsByName("treeView_checkbox");
			for (var i=0; i<input_elements.length; i++) {
				if (expand) {
					if (!input_elements[i].checked) {
						input_elements[i].checked=true;
						showHideSectionsAfterCheckbox(input_elements[i]);
					}
				}
				else {
					if (input_elements[i].checked) {
						input_elements[i].checked=false;
						showHideSectionsAfterCheckbox(input_elements[i]);
					}
				}
			}	
		}
		
		function showHideSectionByNode(node, hideBoolean) {
			for (var sibling=node; sibling!=null; sibling=sibling.nextSibling) {
				with(sibling) {
					if (nodeType == 1) {
						if (className == "treeView_content") {
						    if (hideBoolean) {
						    	style.display="none";
						    }
						    else {
						    	//FireFox table display fix:
						    	if (nodeName.toUpperCase() == "TBODY") {
						    		style.display="table-row-group";
						    	}
						    	else {
						    		style.display="block";
						    	}
						    }
						} 
						else if (className == "treeView") {
							if (nodeName.toLowerCase() == "input") {
								if (type == "hidden") {
									return;
								}
								//Ignore the checkbox input itself
							}
							else if (nodeName.toLowerCase() == "label") {
								for (var i=0; i<childNodes.length; i++) {
									with (childNodes[i]) {
										if (className == "treeView_selector_item") {
											if (hideBoolean) {
												firstChild.nodeValue="+";
											}
											else {
												firstChild.nodeValue="-";
											}
											break;
										}
									}
								}
							}
						} else {
							showHideSectionByNode(childNodes[0], hideBoolean);
						}
					}
				}
			}
		}

      ]]></script>
      	</xsl:when>
      	<xsl:otherwise>
			<xsl:variable name="Url" select="$MirrorServerUrl"/>
			<script src="{$Url}"></script>
		</xsl:otherwise>
		</xsl:choose>

				<title>
					<xsl:value-of select="$V_Title"/>
				</title>
			</head>
			<body style="margin-top:1%" class="default_style">
        <xsl:call-template name="T_header">
          <xsl:with-param name="T_Title" select="$V_Title"/>
        </xsl:call-template>
				<xsl:if test="$V_head_information='true'">
					<p class="p_big"/>
					<xsl:call-template name="T_head_information"/>
				</xsl:if>
				<xsl:if test="$V_diagnosis='true'">
					<p class="p_big"/>
					<xsl:call-template name="T_diagnosis"/>
				</xsl:if>
				<xsl:if test="$V_eventmemory_long='true'">
					<p class="p_big"/>
					<xsl:call-template name="T_eventmemory_long"/>
				</xsl:if>
				<xsl:if test="$V_eventmemory_short='true'">
					<p class="p_big"/>
					<xsl:call-template name="T_eventmemory_short"/>
				</xsl:if>
				<xsl:if test="$V_worksteps='true'">
					<p class="p_big"/>
					<xsl:call-template name="T_worksteps"/>
				</xsl:if>
				<xsl:if test="$V_testplans='true'">
					<p class="p_big"/>
					<xsl:call-template name="T_testplans"/>
				</xsl:if>
				<xsl:if test="$V_functiontests='true'">
					<p class="p_big"/>
					<xsl:call-template name="T_functiontests"/>
				</xsl:if>
				<xsl:if test="$V_last_functiontest='true'">
					<p class="p_big"/>
					<xsl:call-template name="T_last_functiontest"/>
				</xsl:if>
				<xsl:if test="$V_functiontests='true'">
					<p class="p_big"/>
					<xsl:call-template name="T_backgroundtests"/>
				</xsl:if>
			</body>
		</html>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_header -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_header">
    <xsl:param name="T_Title"/>

		<div id="button_bar" class="button_bar">
			<span><button type="button" name="expand_all" onChange="javascript:set_all_treeViews(true);" onClick="javascript:set_all_treeViews(true);">
				<span><xsl:value-of select="$Text_expand_all" /></span>
			</button></span>
			<span><button type="button" name="collapse_all" onChange="javascript:set_all_treeViews(false);" onClick="javascript:set_all_treeViews(false);">
				<span><xsl:value-of select="$Text_collapse_all"></xsl:value-of></span>
			</button></span>
		</div>
		
		<table style="border-bottom-style:groove;border-bottom-color:black;border-bottom-width:2">
			<tr>
				<td style="width:45mm;">
					<p class="header_style_middle">
						<xsl:value-of select="$Text_Odis_Vaudas"/></p>
				</td>
				<td style="width:80mm;text-align:center">
					<p class="header_style_middle">
						<xsl:value-of select="$T_Title"/>
						<xsl:if test="information/is_autosave ='true' or information/is_autosave = '1'">
							<br/>
						</xsl:if>
						<xsl:choose>
							<xsl:when test="$V_protocol_type='long'">
								<xsl:text>(</xsl:text>
								<xsl:value-of select="$Text_diagnosis_protocol_long_title"/>
								<xsl:call-template name="T_autosave">
									<xsl:with-param name="P_string">
										<xsl:value-of select="information/is_autosave"/>
									</xsl:with-param>
								</xsl:call-template>
								<xsl:text>)</xsl:text>							
							</xsl:when>
							<xsl:when test="$V_protocol_type='short'">
								<xsl:text>(</xsl:text>
								<xsl:value-of select="$Text_diagnosis_protocol_short_title"/>
								<xsl:call-template name="T_autosave">
									<xsl:with-param name="P_string">
										<xsl:value-of select="information/is_autosave"/>
									</xsl:with-param>
								</xsl:call-template>
								<xsl:text>)</xsl:text>
							</xsl:when>
							<xsl:when test="$V_protocol_type='functiontest'">
								<xsl:text>(</xsl:text>
								<xsl:value-of select="$Text_diagnosis_protocol_functiontest_title"/>
								<xsl:call-template name="T_autosave">
									<xsl:with-param name="P_string">
										<xsl:value-of select="information/is_autosave"/>
									</xsl:with-param>
								</xsl:call-template>
								<xsl:text>)</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="T_autosave">
									<xsl:with-param name="P_string">
										<xsl:value-of select="information/is_autosave"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose></p>
				</td>
				<td class="align_opposite" style="width:45mm;">
					<p class="header_style_date">
						<xsl:choose>
							<xsl:when test="date_time/moment_of_issue/date/day">							
								<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="date_time/moment_of_issue/date/day"/>
									</xsl:with-param>
								</xsl:call-template>.<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="date_time/moment_of_issue/date/month"/>
									</xsl:with-param>
								</xsl:call-template>.<xsl:value-of select="date_time/moment_of_issue/date/year"/>&#160;
								<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="date_time/moment_of_issue/time/hours"/>
									</xsl:with-param>
								</xsl:call-template>:<xsl:call-template name="T_two_digit">
									<xsl:with-param name="P_string">
										<xsl:value-of select="date_time/moment_of_issue/time/minutes"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<script language="JavaScript">write_date()</script>
							</xsl:otherwise>
						</xsl:choose></p>
				</td>
			</tr>
			<tr>
				<td colspan="3" style="text-align: center;font-size: 8pt">
					XML_to_HTML_Main.xsl Version: 
					<xsl:value-of select="$V_Stylesheet_Version_XML_to_HTML_Main"/>&#160;
					<xsl:value-of select="$Text_from"/>&#160;
					<xsl:value-of select="$V_Stylesheet_Datum_XML_to_HTML_Main"/>
				</td>
			</tr>
			<tr>
				<td colspan="3" style="text-align: center;font-size: 8pt">
					(<xsl:value-of select="confidentiality_level"/>)
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_two_digit-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_two_digit">
		<xsl:param name="P_string"/>
		<xsl:choose>
			<xsl:when test="string-length($P_string) &gt; 1">
				<xsl:value-of select="$P_string"/>
			</xsl:when>
			<xsl:otherwise>0<xsl:value-of select="$P_string"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- **************************************************************************************************************************** -->
	<!-- template T_autosave-->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_autosave">
		<xsl:param name="P_string"/>
		<xsl:choose>
			<xsl:when test="$P_string='true' or $P_string= '1'">
				<xsl:value-of select="$Text_diagnosis_protocol_autosave"/>				
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
