<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="function_templates.xsl" />
	<!-- *************************************************** Versionsvariablen *************** -->
	<!-- %version: $Id: 6026473a6ee27eba63277877e717ea0295033af3 $                                  -->
	<!-- *************************************************** Versionsvariablen *************** -->
	<xsl:variable name="V_Stylesheet_Version_headinformation" select="'1.7'" />
	<xsl:variable name="V_Stylesheet_Datum_headinformation"	select="'18.03.2025'" />
	<!-- **************************************************************************************************************************** -->
	<!-- template T_head_information -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_head_information">
		<p class="header_style_middle_bu">
			<xsl:value-of select="$Text_headline_head_information" /></p>
		<!-- information -->
		<p class="p_small" />
		<table style="width:170mm"> <!-- Breite: 170mm. Vgl. template "T_header" ((45+80+45mm) -->
			<tr>
				<td style="width:60%">
					<span class="general_information_type_title">
						<xsl:value-of select="$Text_order_no" />:&#160;</span>
					<span>
						<xsl:value-of select="information/order_number" /></span>
				</td>
				<td style="width:30mm">
					<p class="general_information_type_title">
						<xsl:value-of select="$Text_protocol_type" />:&#160;</p>
				</td>
				<td>
					<p>
						<xsl:choose>
							<xsl:when test="information/protocol_type='1'">
								<xsl:value-of select="$Text_protocol_type_1" />
							</xsl:when>
							<xsl:when test="information/protocol_type='2'">
								<xsl:value-of select="$Text_protocol_type_2" />
							</xsl:when>
							<xsl:when test="information/protocol_type='3'">
								<xsl:value-of select="$Text_protocol_type_3" />
							</xsl:when>
							<xsl:when test="information/protocol_type='4'">
								<xsl:value-of select="$Text_protocol_type_4" />
							</xsl:when>
							<xsl:when test="information/protocol_type='5'">
								<xsl:value-of select="$Text_protocol_type_5" />
							</xsl:when>
							<xsl:when test="information/protocol_type='6'">
								<xsl:value-of select="$Text_protocol_type_6" />
							</xsl:when>
							<xsl:when test="information/protocol_type='7'">
								<xsl:value-of select="$Text_protocol_type_7" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="information/protocol_type" />
							</xsl:otherwise>
						</xsl:choose></p>
				</td>
			</tr>
			<tr>
				<td style="width:60%" />
				<td style="width:30mm">
					<p class="general_information_type_title">
						<xsl:value-of select="$Text_protocol_status" />:&#160;</p>
				</td>
				<td>
					<p>
						<xsl:choose>
							<xsl:when test="information/protocol_status='final'">
								<xsl:value-of select="$Text_protocol_status_final" />
							</xsl:when>
							<xsl:when
								test="information/protocol_status='intermediate'">
								<xsl:value-of select="$Text_protocol_status_intermediate" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="information/protocol_status" />
							</xsl:otherwise>
						</xsl:choose></p>
				</td>
			</tr>
		</table>
		<!-- workshop_code -->
		<p class="p_small" />
		<p class="default_style_bu">
			<xsl:value-of select="$Text_workshop_information" />
		</p>
		<table>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_workshop_serial_no" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="workshop_code/serial_number" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_workshop_software_name" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="workshop_code/software_name" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_workshop_operatingsystem" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="workshop_code/operatingsystem" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_workshop_vci_type" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="workshop_code/vci_type" />
					<xsl:if test="normalize-space(workshop_code/vci_type/@serial_no_vci)">
						<xsl:text> (</xsl:text><xsl:value-of select="workshop_code/vci_type/@serial_no_vci"/><xsl:text>)</xsl:text>
					</xsl:if>
					</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_workshop_vci_connection_type" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="workshop_code/vci_connection_type" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_workshop_communication_type" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="workshop_code/communication_type/text" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_workshop_importer_no" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="workshop_code/importer_number" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_workshop_garage_no" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="workshop_code/garage_number" /></p>
				</td>
			</tr>
			
			<xsl:for-each select="workshop_code/dealership_identifier/field">
				<tr>
					<xsl:choose>
						<xsl:when test="(position() = 1)">
							<td>
								<p><xsl:value-of select="$Text_workshop_dealership_identifier" />:&#160;</p>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td>
							</td>
						</xsl:otherwise>
					</xsl:choose>
					<td>
						<p><xsl:value-of select="." />&#160;</p>
					</td>
				</tr>
			</xsl:for-each>
			
			<tr>
				<td>
					<p><xsl:value-of select="$Text_workshop_dealerstatusgvo" />:&#160;</p>
				</td>
				<td>
					<p><xsl:choose>
							<xsl:when test="workshop_code/dealer_status_gvo = 1">
								<xsl:value-of select="$Text_workshop_dealerstatusgvo_contractDealer" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$Text_workshop_dealerstatusgvo_freeDealer" />
							</xsl:otherwise>
						</xsl:choose></p>
				</td>
			</tr>

			<tr>
				<td>
					<p><xsl:value-of select="$Text_license_type" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="workshop_code/license_type" /></p>
				</td>
			</tr>
	</table>
		
		<!-- version -->
		<p class="p_small" />
		<p class="default_style_bu"><xsl:value-of select="$Text_sw_versions" />:</p>
		<xsl:call-template name="func_treeView_mark_start">
			<xsl:with-param name="id">
				additional_information
			</xsl:with-param>
		</xsl:call-template>
		
		<table>
			<tr>
				<td>
						<p><xsl:value-of select="$Text_sw_version_vaudas" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="version/Vaudas/name" />&#160;<xsl:value-of select="version/Vaudas/base_patch" />&#160;<xsl:value-of select="version/Vaudas/major" />.<xsl:value-of select="version/Vaudas/minor" />.<xsl:value-of select="version/Vaudas/patch" />&#160;<xsl:value-of select="version/Vaudas/build" />
						<xsl:if test="version/Vaudas/beta_version='true'">
							<xsl:text>(BETA)</xsl:text>
						</xsl:if>
					</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_vaudas_main_feature" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="version/Vaudas/main_feature" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="func_treeView_label">
						<xsl:with-param name="id">
							additional_information
						</xsl:with-param>
						<xsl:with-param name="label">
							<xsl:value-of select="$Text_sw_version_group_point_weitere" />:
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		
		<table class="treeView_content">
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_mcd_server_vendor_name" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="version/mcd_server/vendor_name" />&#160;</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_mcd_server_vendor_product_name" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of
							select="version/mcd_server/vendor_product_name" />&#160;</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_mcd_server_vendor_version" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="version/mcd_server/vendor_version" />&#160;</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_mcd_server_api_version" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="version/mcd_server/mcd_api_version" />&#160;</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_pdu_api_software_name" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="version/pdu_api/pdu_software_name" />&#160;</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_pdu_api_software_version" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of
							select="version/pdu_api/pdu_software_version" />&#160;</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_pdu_api_api_version" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="version/pdu_api/pdu_api_version" />&#160;</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_smard_lang" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="version/test_language/smard_lang" />&#160;</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_vaudas_smard_lang" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of
							select="version/test_language/vaudas_smard_lang" />&#160;</p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_sw_version_vaudas_measurement_types" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of
							select="version/test_language/vaudas_measurement_types" />&#160;</p>
				</td>
			</tr>
			<tr>
				<td>
					<p class="p_small" />
					<p class="default_style_bu"><xsl:value-of select="$Text_installed_gfs" />:&#160;</p>
				</td>
			</tr>
			<xsl:for-each select="version/baseline/installed_gfs_version">
				<tr>
					<td>
						<p><xsl:value-of select="$Text_GFS_marque" />:&#160;</p>
					</td>
					<td>
						<p><xsl:value-of select="marque" /></p>
					</td>
				</tr>
				<tr>
					<td>
						<p><xsl:value-of select="$Text_GFS_version" />:&#160;</p>
					</td>
					 <td>
						<p><xsl:choose>
								<xsl:when test="marketVersion">
									<xsl:value-of select="marketVersion" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="version" />
								</xsl:otherwise>
							</xsl:choose></p>
					</td>
				</tr>
				<tr>
					<td>
						<p><xsl:value-of select="$Text_GFS_language" />:&#160;</p>
					</td>
					<td>
						<p><xsl:value-of select="language" /></p>
					</td>
				</tr>
				<tr>
					<xsl:if test="marketVersion">
						<td>
							<p><xsl:value-of select="$Text_GFS_technicalVersion" />:&#160;</p>
						</td>
						<td>
							<p><xsl:value-of select="version" /></p>
						</td>
					</xsl:if>
				</tr>
				<tr>
					<!-- empty row to separate diagnosis data from each other QC 15013 CCB 746 -->
					<td>
						<p>&#160;</p>
					</td>
					<td>
						<p>&#160;</p>
					</td>
				</tr>
			</xsl:for-each>
			<xsl:for-each select="version/baseline/installed_base_version">
				<tr>
					<td>
						<p><xsl:value-of select="$Text_base_version" />:&#160;</p>
					</td>
					<td>
						<p>
							<xsl:value-of select="version" />
						</p>
					</td>
				</tr>
				<tr>
					<td>
						<p><xsl:value-of select="$Text_base_language" />:&#160;</p>
					</td>
					<td>
						<p><xsl:value-of select="language" /></p>
					</td>
				</tr>
				<tr>
					<!-- empty row to separate diagnosis data from each other QC 15013 CCB 746 -->
					<td>
						<p>&#160;</p>
					</td>
					<td>
						<p>&#160;</p>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<!-- next -->
		<xsl:call-template name="func_treeView_stop" />
		<!-- vehicle data -->
		<p class="p_small" />
		<p class="default_style_bu">
			<xsl:value-of select="$Text_vehicle" />:</p>
		<table>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_vehicle_marque" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of disable-output-escaping="yes" select="vehicle_data/marque" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_vehicle_type" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of disable-output-escaping="yes" select="vehicle_data/type" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_vehicle_model_year" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of disable-output-escaping="yes" select="vehicle_data/model_year" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_vehicle_body_version" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of disable-output-escaping="yes" select="vehicle_data/body_version" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_vehicle_engine_code" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of disable-output-escaping="yes" select="vehicle_data/engine_code" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_vehicle_chassis_number_automatic" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="vehicle_data/chassis_number_automatic" /></p>
				</td>
			</tr>
			<tr>
				<td>
					<p><xsl:value-of select="$Text_vehicle_chassis_number_user" />:&#160;</p>
				</td>
				<td>
					<p><xsl:value-of select="vehicle_data/chassis_number_user" /></p>
				</td>
			</tr>
			<!-- TODO Implement check for existence of node "variable@name='laufleistung'" -->
			<xsl:if
				test="guided_fault_finding/diagnosis_log/global_variables/variable[@name='laufleistung']">
				<tr>
					<td>
						<p><xsl:value-of select="$Text_vehicle_lifetime_mileage_in_km" />:&#160;</p>
					</td>
					<td>
						<p><xsl:value-of select="guided_fault_finding/diagnosis_log/global_variables/variable[@name='laufleistung']" /></p>
					</td>
				</tr>
			</xsl:if>
			<xsl:if
				test="string-length(vehicle_data/asam_information/asam_project_name)>0">
				<tr>
					<td>
						<p><xsl:value-of select="$Text_vehicle_asam_name" />&#160;</p>
					</td>
					<td>
						<p><xsl:value-of select="vehicle_data/asam_information/asam_project_name" /></p>
					</td>
				</tr>
			</xsl:if>
			<xsl:if
				test="string-length(vehicle_data/asam_information/asam_project_version)>0">
				<tr>
					<td>
						<p><xsl:value-of select="$Text_vehicle_asam_version" />&#160;</p>
					</td>
					<td>
						<p><xsl:value-of select="vehicle_data/asam_information/asam_project_version" /></p>
					</td>
				</tr>
			</xsl:if>
      <xsl:if test="vehicle_data/cooperation">
        <tr>
          <td>
            <p><xsl:value-of select="$Text_cooperation"/>&#160;</p>
          </td>
          <td>
            <p>
              <xsl:value-of select="vehicle_data/cooperation"/>
            </p>
          </td>
        </tr>
      </xsl:if>
		</table>

		<!-- regulation based software identification -->
		<p class="p_small" />
		<p class="default_style_bu">
			<xsl:value-of select="$Text_regulation_based_sw_ident" />:
		</p>
		<xsl:for-each select="rxswins/rxswin_read_block">
			<xsl:call-template name="T_head_RxSWIN_information" />
		</xsl:for-each>
	</xsl:template>
	
	
	<!-- **************************************************************************************************************************** -->
	<!-- template T_head_RxSWIN_information (displays timestamp and values as a table) -->
	<!-- **************************************************************************************************************************** -->
	<xsl:template name="T_head_RxSWIN_information">
		<xsl:call-template name="func_treeView_mark_start">
			<xsl:with-param name="id">
				RxSWIN_information_<xsl:value-of select="generate-id(.)" />
			</xsl:with-param>
		</xsl:call-template>
		<table>
			<tr>
				<td>
					<xsl:call-template name="func_treeView_label">
						<xsl:with-param name="id">RxSWIN_information_<xsl:value-of select="generate-id(.)" /></xsl:with-param>
						<xsl:with-param name="label">
							<xsl:call-template name="T_dateTime"><xsl:with-param name="dateTime" select="./read_time"/></xsl:call-template>
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	
		<table class="treeView_content">
			<tr class="default_style_b">
				<td>
					<xsl:value-of select="$Text_regulation_ident" />
				</td>
				<td>
					<xsl:value-of select="$Text_sw_ident" />
				</td>
			</tr>
			<xsl:for-each select="./rxswin">
				<tr>
					<td>
						<xsl:value-of select="./regulation_ident" />
					</td>
					<td>
						<xsl:value-of select="./software_ident" />
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<xsl:call-template name="func_treeView_stop" />
	</xsl:template>
</xsl:stylesheet>
