/*!
 * \file    hvmt-comm.h
 * \version 1.4.0.0
 * \date    10.07.2020
 * \author  rd electronic GmbH (rde)
 *
 * \hist    \li 1.4.0.0		10.07.2020	rde		TIoData geändert auf IP-Parametrierung
 *			\li 1.3.0.0		22.11.2011	rde		TIoData angepasst
 *			\li	1.0.0.0		11.11.2011	rde		Erstellung
 *
 * \brief   Datentypen fuer Kommunikationsparameter.
 *
 */
 typedef enum TeEndpointType
{
	// Verbindungsaufbau über serielle Schnittstelle
    eEptSerial,
	// Verbindungsaufbau über TCP-Server
    eEptTcpName,
	// Verbindungsaufbau über TCP-Server
    eEptTcpIp4	
	
} TeEndpointType;

typedef struct TTcpName
{
    // Hostname
    A_ASCIISTRING_64	sHostname;
	// Portnummer des TCP-Servers
    A_UINT16			unPort;

}TTcpName;

typedef struct TTcpIp4
{
	// IPv4-Adresse
    A_IP4				tHostAddress;
	// Portnummer des TCP-Servers
    A_UINT16			unPort;

}TTcpIp4;

/*!
 * \brief   Datentyp fuer die Kommunikationsparameter.
 *
 * \note    Der Verbindungsaufbau zu einem direkt mit dem PC verbundenen VAS6558 erfolgt über die
 *			Portnummer (ucSerialPort). Zum Verbindungsaufbau mit VAS6558-Geräten im Intranet kann
 *			eine IPv4- oder eine IPv6-Adresse verwendet werden.
 */
typedef union TuIoData switch (TeEndpointType)
{
	// Verbindungsdaten zum seriellen Port
	case eEptSerial		:	A_UINT8 ucSerialPort;
	// Verbindungsdaten zum TCP-Server
    case eEptTcpName	:	TTcpName tTcpName;
	// Verbindungsdaten zum TCP-Server
    case eEptTcpIp4		:	TTcpIp4 tTcpIp4;
		
} TuIoData;
