/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import org.eclipse.nebula.paperclips.core.AlignPrint;
import org.eclipse.nebula.paperclips.core.CompositeEntry;
import org.eclipse.nebula.paperclips.core.CompositePiece;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class AlignIterator
implements PrintIterator {
    private final PrintIterator target;
    private final int hAlign;
    private final int vAlign;

    AlignIterator(AlignPrint print, Device device, GC gc) {
        this.target = print.target.iterator(device, gc);
        this.hAlign = print.hAlign;
        this.vAlign = print.vAlign;
    }

    AlignIterator(AlignIterator that) {
        this.target = that.target.copy();
        this.hAlign = that.hAlign;
        this.vAlign = that.vAlign;
    }

    @Override
    public boolean hasNext() {
        return this.target.hasNext();
    }

    @Override
    public Point minimumSize() {
        return this.target.minimumSize();
    }

    @Override
    public Point preferredSize() {
        return this.target.preferredSize();
    }

    @Override
    public PrintPiece next(int width, int height) {
        PrintPiece piece = PaperClips.next(this.target, width, height);
        if (piece == null) {
            return null;
        }
        Point size = piece.getSize();
        Point offset = new Point(0, 0);
        if (this.hAlign == 0x1000000) {
            offset.x = (width - size.x) / 2;
        } else if (this.hAlign == 131072) {
            offset.x = width - size.x;
        }
        if (this.hAlign != 16384) {
            size.x = width;
        }
        if (this.vAlign == 0x1000000) {
            offset.y = (height - size.y) / 2;
        } else if (this.vAlign == 1024) {
            offset.y = height - size.y;
        }
        if (this.vAlign != 128) {
            size.y = height;
        }
        CompositeEntry entry = new CompositeEntry(piece, offset);
        return new CompositePiece(new CompositeEntry[]{entry}, size);
    }

    @Override
    public PrintIterator copy() {
        return new AlignIterator(this);
    }
}

