/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.paperclips.core.CompositeEntry;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class CompositePiece
implements PrintPiece {
    private final Point size;
    private final CompositeEntry[] entries;

    public CompositePiece(CompositeEntry[] entries) {
        this(CompositePiece.createList(entries));
    }

    public CompositePiece(CompositeEntry[] entries, Point size) {
        this(CompositePiece.createList(entries), size);
    }

    private static List<CompositeEntry> createList(CompositeEntry[] entries) {
        ArrayList<CompositeEntry> result = new ArrayList<CompositeEntry>();
        int i = 0;
        while (i < entries.length) {
            result.add(entries[i]);
            ++i;
        }
        return result;
    }

    public CompositePiece(List<CompositeEntry> entries) {
        this(entries, new Point(0, 0));
    }

    public CompositePiece(List<CompositeEntry> entries, Point size) {
        Util.noNulls(entries);
        this.entries = entries.toArray(new CompositeEntry[entries.size()]);
        this.size = new Point(size.x, size.y);
        int i = 0;
        while (i < this.entries.length) {
            CompositeEntry entry = this.entries[i];
            Point pieceSize = entry.piece.getSize();
            this.size.x = Math.max(this.size.x, entry.offset.x + pieceSize.x);
            this.size.y = Math.max(this.size.y, entry.offset.y + pieceSize.y);
            ++i;
        }
    }

    @Override
    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    @Override
    public void paint(GC gc, int x, int y) {
        int i = 0;
        while (i < this.entries.length) {
            CompositeEntry entry = this.entries[i];
            entry.piece.paint(gc, x + entry.offset.x, y + entry.offset.y);
            ++i;
        }
    }

    @Override
    public void dispose() {
        int i = 0;
        while (i < this.entries.length) {
            this.entries[i].dispose();
            ++i;
        }
    }
}

